/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.LifecyleInterceptorInvocation;
import io.undertow.servlet.spec.FilterConfigImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;

public class ManagedFilter
implements Lifecycle {
    private final FilterInfo filterInfo;
    private final ServletContextImpl servletContext;
    private static final int FLAG_STARTED = 1;
    private static final int FLAG_STOPPED = 2;
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<ManagedFilter> stateFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(ManagedFilter.class, "state");
    private volatile Filter filter;
    private volatile InstanceHandle<? extends Filter> handle;

    public ManagedFilter(FilterInfo filterInfo, ServletContextImpl servletContext) {
        this.filterInfo = filterInfo;
        this.servletContext = servletContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.servletContext.getDeployment().getDeploymentState() != DeploymentManager.State.STARTED) {
            throw UndertowServletMessages.MESSAGES.deploymentStopped(this.servletContext.getDeployment().getDeploymentInfo().getDeploymentName());
        }
        this.start();
        this.getFilter().doFilter(request, response, chain);
    }

    private Filter getFilter() throws ServletException {
        if (this.filter == null) {
            this.createFilter();
        }
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFilter() throws ServletException {
        ManagedFilter managedFilter = this;
        synchronized (managedFilter) {
            if (this.filter == null) {
                try {
                    this.handle = this.filterInfo.getInstanceFactory().createInstance();
                }
                catch (Exception e) {
                    throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(this.filterInfo.getName(), e);
                }
                Filter filter2 = this.handle.getInstance();
                new LifecyleInterceptorInvocation(this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors(), this.filterInfo, filter2, new FilterConfigImpl(this.filterInfo, this.servletContext)).proceed();
                this.filter = filter2;
            }
        }
    }

    @Override
    public void start() throws ServletException {
        do {
            if (!Bits.anyAreSet(stateFieldUpdater.get(this), 2)) continue;
            throw UndertowServletMessages.MESSAGES.deploymentStopped(this.servletContext.getDeployment().getDeploymentInfo().getDeploymentName());
        } while (stateFieldUpdater.get(this) != 1 && !stateFieldUpdater.compareAndSet(this, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        stateFieldUpdater.set(this, 2);
        ManagedFilter managedFilter = this;
        synchronized (managedFilter) {
            if (this.handle != null) {
                try {
                    new LifecyleInterceptorInvocation(this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors(), this.filterInfo, this.filter).proceed();
                }
                catch (Exception e) {
                    UndertowServletLogger.ROOT_LOGGER.failedToDestroy(this.filterInfo, e);
                }
                this.handle.release();
            }
            this.filter = null;
            this.handle = null;
        }
    }

    @Override
    public boolean isStarted() {
        return Bits.anyAreSet(this.state, 1);
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public String toString() {
        return "ManagedFilter{filterInfo=" + this.filterInfo + "}";
    }

    public void forceInit() throws ServletException {
        if (this.filter == null) {
            this.createFilter();
        }
    }
}

