/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.CrawlerSessionManagerConfig;
import io.undertow.servlet.handlers.CrawlerBindingListener;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import jakarta.servlet.http.HttpSession;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class CrawlerSessionManagerHandler
implements HttpHandler {
    private static final String SESSION_ATTRIBUTE_NAME = "listener_" + CrawlerSessionManagerHandler.class.getName();
    private final Map<String, String> clientIpSessionId = new ConcurrentHashMap<String, String>();
    private final Map<String, String> sessionIdClientIp = new ConcurrentHashMap<String, String>();
    private final CrawlerSessionManagerConfig config;
    private final Pattern uaPattern;
    private final HttpHandler next;

    public CrawlerSessionManagerHandler(CrawlerSessionManagerConfig config, HttpHandler next) {
        this.config = config;
        this.next = next;
        this.uaPattern = Pattern.compile(config.getCrawlerUserAgents());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        HeaderValues userAgentHeaders;
        boolean isBot = false;
        String sessionId = null;
        String clientIp = null;
        ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (src.getOriginalRequest().getSession(false) == null && (userAgentHeaders = exchange2.getRequestHeaders().get(Headers.USER_AGENT)) != null) {
            Iterator<String> uaHeaders = userAgentHeaders.iterator();
            String uaHeader = null;
            if (uaHeaders.hasNext()) {
                uaHeader = uaHeaders.next();
            }
            if (uaHeader != null && !uaHeaders.hasNext() && this.uaPattern.matcher(uaHeader).matches()) {
                isBot = true;
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debug(exchange2 + ": Bot found. UserAgent=" + uaHeader);
                }
            }
            if (isBot && (sessionId = this.clientIpSessionId.get(clientIp = src.getServletRequest().getRemoteAddr())) != null) {
                src.setOverridenSessionId(sessionId);
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debug(exchange2 + ": SessionID=" + sessionId);
                }
            }
        }
        if (isBot) {
            final String finalSessionId = sessionId;
            final String finalClientId = clientIp;
            exchange2.addExchangeCompleteListener(new ExchangeCompletionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void exchangeEvent(HttpServerExchange exchange2, ExchangeCompletionListener.NextListener nextListener) {
                    try {
                        ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                        if (finalSessionId == null) {
                            HttpSession s = src.getOriginalRequest().getSession(false);
                            if (s != null) {
                                CrawlerSessionManagerHandler.this.clientIpSessionId.put(finalClientId, s.getId());
                                CrawlerSessionManagerHandler.this.sessionIdClientIp.put(s.getId(), finalClientId);
                                s.setAttribute(SESSION_ATTRIBUTE_NAME, new CrawlerBindingListener(CrawlerSessionManagerHandler.this.clientIpSessionId, CrawlerSessionManagerHandler.this.sessionIdClientIp));
                                s.setMaxInactiveInterval(CrawlerSessionManagerHandler.this.config.getSessionInactiveInterval());
                                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                                    UndertowLogger.REQUEST_LOGGER.debug(exchange2 + ": New bot session. SessionID=" + s.getId());
                                }
                            }
                        } else if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            UndertowLogger.REQUEST_LOGGER.debug(exchange2 + ": Bot session accessed. SessionID=" + finalSessionId);
                        }
                    }
                    finally {
                        nextListener.proceed();
                    }
                }
            });
        }
        this.next.handleRequest(exchange2);
    }
}

