/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.RedirectBuilder;

public class RedirectDirHandler
implements HttpHandler {
    private static final String HTTP2_UPGRADE_PREFIX = "h2";
    private final HttpHandler next;
    private final ServletPathMatches paths;

    public RedirectDirHandler(HttpHandler next, ServletPathMatches paths) {
        this.next = next;
        this.paths = paths;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        boolean isUpgradeRequest;
        String path = exchange2.getRelativePath();
        ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        String upgradeString = exchange2.getRequestHeaders().getFirst(Headers.UPGRADE);
        boolean bl = isUpgradeRequest = upgradeString != null && !upgradeString.startsWith(HTTP2_UPGRADE_PREFIX);
        if (info.getType() == ServletPathMatch.Type.REDIRECT && !isUpgradeRequest) {
            if (exchange2.getRequestMethod().equals(Methods.GET) || exchange2.getRequestMethod().equals(Methods.HEAD)) {
                exchange2.setStatusCode(302);
            } else {
                exchange2.setStatusCode(307);
            }
            exchange2.getResponseHeaders().put(Headers.LOCATION, RedirectBuilder.redirect(exchange2, exchange2.getRelativePath() + "/", true));
            return;
        }
        this.next.handleRequest(exchange2);
    }
}

