/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.net.URISyntaxException;

public class ServletConfidentialityConstraintHandler
extends SinglePortConfidentialityHandler {
    private final ConfidentialPortManager portManager;

    public ServletConfidentialityConstraintHandler(ConfidentialPortManager portManager, HttpHandler next) {
        super(next, -1);
        this.portManager = portManager;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        ServletRequestContext servletRequestContext = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        AuthorizationManager authorizationManager = servletRequestContext.getDeployment().getDeploymentInfo().getAuthorizationManager();
        TransportGuaranteeType connectionGuarantee = servletRequestContext.getOriginalRequest().isSecure() ? TransportGuaranteeType.CONFIDENTIAL : TransportGuaranteeType.NONE;
        TransportGuaranteeType transportGuarantee = authorizationManager.transportGuarantee(connectionGuarantee, servletRequestContext.getTransportGuarenteeType(), servletRequestContext.getOriginalRequest());
        servletRequestContext.setTransportGuarenteeType(transportGuarantee);
        if (TransportGuaranteeType.REJECTED == transportGuarantee) {
            HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
            response.sendError(403);
            return;
        }
        super.handleRequest(exchange2);
    }

    @Override
    protected boolean confidentialityRequired(HttpServerExchange exchange2) {
        TransportGuaranteeType transportGuarantee = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY).getTransportGuarenteeType();
        return TransportGuaranteeType.CONFIDENTIAL == transportGuarantee || TransportGuaranteeType.INTEGRAL == transportGuarantee;
    }

    @Override
    protected URI getRedirectURI(HttpServerExchange exchange2) throws URISyntaxException {
        int port = this.portManager.getConfidentialPort(exchange2);
        if (port < 0) {
            throw UndertowServletMessages.MESSAGES.noConfidentialPortAvailable();
        }
        return super.getRedirectURI(exchange2, port);
    }

    @Override
    protected boolean isConfidential(HttpServerExchange exchange2) {
        ServletRequestContext src = exchange2.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (src != null) {
            return src.getOriginalRequest().isSecure();
        }
        return super.isConfidential(exchange2);
    }
}

