/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.wildfly.common.Assert;

public final class HeaderMap
implements Iterable<HeaderValues> {
    private Object[] table = new Object[16];
    private int size;
    private Collection<HttpString> headerNames;

    private HeaderValues getEntry(HttpString headerName) {
        if (headerName == null) {
            return null;
        }
        int hc = headerName.hashCode();
        int idx = hc & this.table.length - 1;
        Object o = this.table[idx];
        if (o == null) {
            return null;
        }
        if (o instanceof HeaderValues) {
            HeaderValues headerValues = (HeaderValues)o;
            if (!headerName.equals(headerValues.key)) {
                return null;
            }
            return headerValues;
        }
        HeaderValues[] row = (HeaderValues[])o;
        for (int i = 0; i < row.length; ++i) {
            HeaderValues headerValues = row[i];
            if (headerValues == null || !headerName.equals(headerValues.key)) continue;
            return headerValues;
        }
        return null;
    }

    private HeaderValues getEntry(String headerName) {
        if (headerName == null) {
            return null;
        }
        int hc = HttpString.hashCodeOf(headerName);
        int idx = hc & this.table.length - 1;
        Object o = this.table[idx];
        if (o == null) {
            return null;
        }
        if (o instanceof HeaderValues) {
            HeaderValues headerValues = (HeaderValues)o;
            if (!headerValues.key.equalToString(headerName)) {
                return null;
            }
            return headerValues;
        }
        HeaderValues[] row = (HeaderValues[])o;
        for (int i = 0; i < row.length; ++i) {
            HeaderValues headerValues = row[i];
            if (headerValues == null || !headerValues.key.equalToString(headerName)) continue;
            return headerValues;
        }
        return null;
    }

    private HeaderValues removeEntry(HttpString headerName) {
        if (headerName == null) {
            return null;
        }
        Object[] table = this.table;
        int hc = headerName.hashCode();
        int idx = hc & table.length - 1;
        Object o = table[idx];
        if (o == null) {
            return null;
        }
        if (o instanceof HeaderValues) {
            HeaderValues headerValues = (HeaderValues)o;
            if (!headerName.equals(headerValues.key)) {
                return null;
            }
            table[idx] = null;
            --this.size;
            return headerValues;
        }
        HeaderValues[] row = (HeaderValues[])o;
        for (int i = 0; i < row.length; ++i) {
            HeaderValues headerValues = row[i];
            if (headerValues == null || !headerName.equals(headerValues.key)) continue;
            row[i] = null;
            --this.size;
            return headerValues;
        }
        return null;
    }

    private HeaderValues removeEntry(String headerName) {
        if (headerName == null) {
            return null;
        }
        Object[] table = this.table;
        int hc = HttpString.hashCodeOf(headerName);
        int idx = hc & table.length - 1;
        Object o = table[idx];
        if (o == null) {
            return null;
        }
        if (o instanceof HeaderValues) {
            HeaderValues headerValues = (HeaderValues)o;
            if (!headerValues.key.equalToString(headerName)) {
                return null;
            }
            table[idx] = null;
            --this.size;
            return headerValues;
        }
        HeaderValues[] row = (HeaderValues[])o;
        for (int i = 0; i < row.length; ++i) {
            HeaderValues headerValues = row[i];
            if (headerValues == null || !headerValues.key.equalToString(headerName)) continue;
            row[i] = null;
            --this.size;
            return headerValues;
        }
        return null;
    }

    private void resize() {
        int oldLen = this.table.length;
        if (oldLen == 0x40000000) {
            return;
        }
        assert (Integer.bitCount(oldLen) == 1);
        Object[] newTable = Arrays.copyOf(this.table, oldLen << 1);
        this.table = newTable;
        for (int i = 0; i < oldLen; ++i) {
            if (newTable[i] == null) continue;
            if (newTable[i] instanceof HeaderValues) {
                HeaderValues e = (HeaderValues)newTable[i];
                if ((e.key.hashCode() & oldLen) == 0) continue;
                newTable[i] = null;
                newTable[i + oldLen] = e;
                continue;
            }
            HeaderValues[] oldRow = (HeaderValues[])newTable[i];
            HeaderValues[] newRow = (HeaderValues[])oldRow.clone();
            int rowLen = oldRow.length;
            newTable[i + oldLen] = newRow;
            for (int j = 0; j < rowLen; ++j) {
                HeaderValues item = oldRow[j];
                if (item == null) continue;
                if ((item.key.hashCode() & oldLen) != 0) {
                    oldRow[j] = null;
                    continue;
                }
                newRow[j] = null;
            }
        }
    }

    private HeaderValues getOrCreateEntry(HttpString headerName) {
        int length;
        if (headerName == null) {
            return null;
        }
        Object[] table = this.table;
        int hc = headerName.hashCode();
        int idx = hc & (length = table.length) - 1;
        Object o = table[idx];
        if (o == null) {
            if (this.size >= length >> 1) {
                this.resize();
                return this.getOrCreateEntry(headerName);
            }
            HeaderValues headerValues = new HeaderValues(headerName);
            table[idx] = headerValues;
            ++this.size;
            return headerValues;
        }
        return this.getOrCreateNonEmpty(headerName, table, length, idx, o);
    }

    private HeaderValues getOrCreateNonEmpty(HttpString headerName, Object[] table, int length, int idx, Object o) {
        HeaderValues headerValues;
        if (o instanceof HeaderValues) {
            HeaderValues headerValues2 = (HeaderValues)o;
            if (!headerName.equals(headerValues2.key)) {
                HeaderValues[] row;
                if (this.size >= length >> 1) {
                    this.resize();
                    return this.getOrCreateEntry(headerName);
                }
                ++this.size;
                table[idx] = row = new HeaderValues[]{headerValues2, new HeaderValues(headerName), null, null};
                return row[1];
            }
            return headerValues2;
        }
        HeaderValues[] row = (HeaderValues[])o;
        int empty = -1;
        for (int i = 0; i < row.length; ++i) {
            headerValues = row[i];
            if (headerValues != null) {
                if (!headerName.equals(headerValues.key)) continue;
                return headerValues;
            }
            if (empty != -1) continue;
            empty = i;
        }
        if (this.size >= length >> 1) {
            this.resize();
            return this.getOrCreateEntry(headerName);
        }
        ++this.size;
        headerValues = new HeaderValues(headerName);
        if (empty != -1) {
            row[empty] = headerValues;
        } else {
            if (row.length >= 16) {
                throw new SecurityException("Excessive collisions");
            }
            HeaderValues[] newRow = Arrays.copyOf(row, row.length + 3);
            newRow[row.length] = headerValues;
            table[idx] = newRow;
        }
        return headerValues;
    }

    public HeaderValues get(HttpString headerName) {
        return this.getEntry(headerName);
    }

    public HeaderValues get(String headerName) {
        return this.getEntry(headerName);
    }

    public String getFirst(HttpString headerName) {
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return null;
        }
        return headerValues.getFirst();
    }

    public String getFirst(String headerName) {
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return null;
        }
        return headerValues.getFirst();
    }

    public String get(HttpString headerName, int index) throws IndexOutOfBoundsException {
        if (headerName == null) {
            return null;
        }
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return null;
        }
        return headerValues.get(index);
    }

    public String get(String headerName, int index) throws IndexOutOfBoundsException {
        if (headerName == null) {
            return null;
        }
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return null;
        }
        return headerValues.get(index);
    }

    public String getLast(HttpString headerName) {
        if (headerName == null) {
            return null;
        }
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return null;
        }
        return headerValues.getLast();
    }

    public String getLast(String headerName) {
        if (headerName == null) {
            return null;
        }
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return null;
        }
        return headerValues.getLast();
    }

    public int count(HttpString headerName) {
        if (headerName == null) {
            return 0;
        }
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return 0;
        }
        return headerValues.size();
    }

    public int count(String headerName) {
        if (headerName == null) {
            return 0;
        }
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null) {
            return 0;
        }
        return headerValues.size();
    }

    public int size() {
        return this.size;
    }

    public long fastIterate() {
        Object[] table = this.table;
        int len = table.length;
        for (int ri = 0; ri < len; ++ri) {
            Object item = table[ri];
            if (item == null) continue;
            if (item instanceof HeaderValues) {
                return (long)ri << 32;
            }
            HeaderValues[] row = (HeaderValues[])item;
            int rowLen = row.length;
            for (int ci = 0; ci < rowLen; ++ci) {
                if (row[ci] == null) continue;
                return (long)ri << 32 | (long)ci & 0xFFFFFFFFL;
            }
        }
        return -1L;
    }

    public long fastIterateNonEmpty() {
        Object[] table = this.table;
        int len = table.length;
        for (int ri = 0; ri < len; ++ri) {
            Object item = table[ri];
            if (item == null) continue;
            if (item instanceof HeaderValues) {
                if (((HeaderValues)item).isEmpty()) continue;
                return (long)ri << 32;
            }
            HeaderValues[] row = (HeaderValues[])item;
            int rowLen = row.length;
            for (int ci = 0; ci < rowLen; ++ci) {
                if (row[ci] == null || row[ci].isEmpty()) continue;
                return (long)ri << 32 | (long)ci & 0xFFFFFFFFL;
            }
        }
        return -1L;
    }

    public long fiNext(long cookie) {
        int rowLen;
        HeaderValues[] row;
        if (cookie == -1L) {
            return -1L;
        }
        Object[] table = this.table;
        int len = table.length;
        int ri = (int)(cookie >> 32);
        int ci = (int)cookie;
        Object item = table[ri];
        if (item instanceof HeaderValues[]) {
            row = (HeaderValues[])item;
            rowLen = row.length;
            if (++ci >= rowLen) {
                ++ri;
                ci = 0;
            } else if (row[ci] != null) {
                return (long)ri << 32 | (long)ci & 0xFFFFFFFFL;
            }
        } else {
            ++ri;
            ci = 0;
        }
        while (ri < len) {
            item = table[ri];
            if (item instanceof HeaderValues) {
                return (long)ri << 32;
            }
            if (item instanceof HeaderValues[]) {
                row = (HeaderValues[])item;
                rowLen = row.length;
                while (ci < rowLen) {
                    if (row[ci] != null) {
                        return (long)ri << 32 | (long)ci & 0xFFFFFFFFL;
                    }
                    ++ci;
                }
            }
            ci = 0;
            ++ri;
        }
        return -1L;
    }

    public long fiNextNonEmpty(long cookie) {
        int rowLen;
        HeaderValues[] row;
        if (cookie == -1L) {
            return -1L;
        }
        Object[] table = this.table;
        int len = table.length;
        int ri = (int)(cookie >> 32);
        int ci = (int)cookie;
        Object item = table[ri];
        if (item instanceof HeaderValues[]) {
            row = (HeaderValues[])item;
            rowLen = row.length;
            if (++ci >= rowLen) {
                ++ri;
                ci = 0;
            } else if (row[ci] != null && !row[ci].isEmpty()) {
                return (long)ri << 32 | (long)ci & 0xFFFFFFFFL;
            }
        } else {
            ++ri;
            ci = 0;
        }
        while (ri < len) {
            item = table[ri];
            if (item instanceof HeaderValues && !((HeaderValues)item).isEmpty()) {
                return (long)ri << 32;
            }
            if (item instanceof HeaderValues[]) {
                row = (HeaderValues[])item;
                rowLen = row.length;
                while (ci < rowLen) {
                    if (row[ci] != null && !row[ci].isEmpty()) {
                        return (long)ri << 32 | (long)ci & 0xFFFFFFFFL;
                    }
                    ++ci;
                }
            }
            ci = 0;
            ++ri;
        }
        return -1L;
    }

    public HeaderValues fiCurrent(long cookie) {
        try {
            Object[] table = this.table;
            int ri = (int)(cookie >> 32);
            int ci = (int)cookie;
            Object item = table[ri];
            if (item instanceof HeaderValues[]) {
                return ((HeaderValues[])item)[ci];
            }
            if (ci == 0) {
                return (HeaderValues)item;
            }
            throw new NoSuchElementException();
        }
        catch (RuntimeException e) {
            throw new NoSuchElementException();
        }
    }

    public Iterable<String> eachValue(HttpString headerName) {
        if (headerName == null) {
            return Collections.emptyList();
        }
        HeaderValues entry = this.getEntry(headerName);
        if (entry == null) {
            return Collections.emptyList();
        }
        return entry;
    }

    @Override
    public Iterator<HeaderValues> iterator() {
        return new Iterator<HeaderValues>(){
            final Object[] table;
            boolean consumed;
            int ri;
            int ci;
            {
                this.table = HeaderMap.this.table;
            }

            private HeaderValues _next() {
                HeaderValues headerValues;
                while (true) {
                    if (this.ri >= this.table.length) {
                        return null;
                    }
                    Object o = this.table[this.ri];
                    if (o == null) {
                        ++this.ri;
                        this.ci = 0;
                        this.consumed = false;
                        continue;
                    }
                    if (o instanceof HeaderValues) {
                        if (this.ci > 0 || this.consumed) {
                            ++this.ri;
                            this.ci = 0;
                            this.consumed = false;
                            continue;
                        }
                        return (HeaderValues)o;
                    }
                    HeaderValues[] row = (HeaderValues[])o;
                    int len = row.length;
                    if (this.ci >= len) {
                        ++this.ri;
                        this.ci = 0;
                        this.consumed = false;
                        continue;
                    }
                    if (this.consumed) {
                        ++this.ci;
                        this.consumed = false;
                        continue;
                    }
                    headerValues = row[this.ci];
                    if (headerValues != null) break;
                    ++this.ci;
                }
                return headerValues;
            }

            @Override
            public boolean hasNext() {
                return this._next() != null;
            }

            @Override
            public HeaderValues next() {
                HeaderValues next = this._next();
                if (next == null) {
                    throw new NoSuchElementException();
                }
                this.consumed = true;
                return next;
            }

            @Override
            public void remove() {
            }
        };
    }

    public Collection<HttpString> getHeaderNames() {
        if (this.headerNames != null) {
            return this.headerNames;
        }
        this.headerNames = new AbstractCollection<HttpString>(){

            @Override
            public boolean contains(Object o) {
                return o instanceof HttpString && HeaderMap.this.getEntry((HttpString)o) != null;
            }

            @Override
            public boolean add(HttpString httpString) {
                HeaderMap.this.getOrCreateEntry(httpString);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof HttpString)) {
                    return false;
                }
                HttpString s = (HttpString)o;
                HeaderValues entry = HeaderMap.this.getEntry(s);
                if (entry == null) {
                    return false;
                }
                entry.clear();
                return true;
            }

            @Override
            public void clear() {
                HeaderMap.this.clear();
            }

            @Override
            public Iterator<HttpString> iterator() {
                final Iterator<HeaderValues> iterator = HeaderMap.this.iterator();
                return new Iterator<HttpString>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public HttpString next() {
                        return ((HeaderValues)iterator.next()).getHeaderName();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return HeaderMap.this.size();
            }
        };
        return this.headerNames;
    }

    public HeaderMap add(HttpString headerName, String headerValue) {
        this.addLast(headerName, headerValue);
        return this;
    }

    public HeaderMap addFirst(HttpString headerName, String headerValue) {
        Assert.checkNotNullParam("headerName", headerName);
        if (headerValue == null) {
            return this;
        }
        this.getOrCreateEntry(headerName).addFirst(headerValue);
        return this;
    }

    public HeaderMap addLast(HttpString headerName, String headerValue) {
        Assert.checkNotNullParam("headerName", headerName);
        if (headerValue == null) {
            return this;
        }
        this.getOrCreateEntry(headerName).addLast(headerValue);
        return this;
    }

    public HeaderMap add(HttpString headerName, long headerValue) {
        this.add(headerName, Long.toString(headerValue));
        return this;
    }

    public HeaderMap addAll(HttpString headerName, Collection<String> headerValues) {
        Assert.checkNotNullParam("headerName", headerName);
        if (headerValues == null || headerValues.isEmpty()) {
            return this;
        }
        this.getOrCreateEntry(headerName).addAll((Collection<? extends String>)headerValues);
        return this;
    }

    public HeaderMap put(HttpString headerName, String headerValue) {
        Assert.checkNotNullParam("headerName", headerName);
        if (headerValue == null) {
            this.remove(headerName);
            return this;
        }
        HeaderValues headerValues = this.getOrCreateEntry(headerName);
        headerValues.clear();
        headerValues.add(headerValue);
        return this;
    }

    public HeaderMap put(HttpString headerName, long headerValue) {
        Assert.checkNotNullParam("headerName", headerName);
        HeaderValues entry = this.getOrCreateEntry(headerName);
        entry.clear();
        entry.add(Long.toString(headerValue));
        return this;
    }

    public HeaderMap putAll(HttpString headerName, Collection<String> headerValues) {
        Assert.checkNotNullParam("headerName", headerName);
        if (headerValues == null || headerValues.isEmpty()) {
            this.remove(headerName);
            return this;
        }
        HeaderValues entry = this.getOrCreateEntry(headerName);
        entry.clear();
        entry.addAll((Collection<? extends String>)headerValues);
        return this;
    }

    public HeaderMap putAll(HeaderMap headerMap) {
        Assert.checkNotNullParam("headerMap", headerMap);
        for (HeaderValues headerValues : headerMap) {
            this.putAll(headerValues.getHeaderName(), headerValues);
        }
        return this;
    }

    public HeaderMap clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        return this;
    }

    public Collection<String> remove(HttpString headerName) {
        if (headerName == null) {
            return Collections.emptyList();
        }
        HeaderValues values = this.removeEntry(headerName);
        return values != null ? values : Collections.emptyList();
    }

    public Collection<String> remove(String headerName) {
        if (headerName == null) {
            return Collections.emptyList();
        }
        HeaderValues values = this.removeEntry(headerName);
        return values != null ? values : Collections.emptyList();
    }

    public boolean contains(HttpString headerName) {
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null || headerValues.size == 0) {
            return false;
        }
        Object v = headerValues.value;
        if (v instanceof String) {
            return true;
        }
        String[] list = (String[])v;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String headerName) {
        HeaderValues headerValues = this.getEntry(headerName);
        if (headerValues == null || headerValues.size == 0) {
            return false;
        }
        Object v = headerValues.value;
        if (v instanceof String) {
            return true;
        }
        String[] list = (String[])v;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (HttpString name : this.getHeaderNames()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(name);
            sb.append("=[");
            boolean f = true;
            for (String val : this.get(name)) {
                if (f) {
                    f = false;
                } else {
                    sb.append(", ");
                }
                sb.append(val);
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }
}

