/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplate;
import io.undertow.util.URLUtils;
import org.apache.camel.component.undertow.handlers.CamelMethodHandler;
import org.apache.camel.component.undertow.handlers.CamelPathHandler;
import org.apache.camel.component.undertow.handlers.CamelPathTemplateHandler;

public class CamelRootHandler
implements HttpHandler {
    private final CamelPathHandler pathHandler;

    public CamelRootHandler(HttpHandler defaultHandler) {
        this.pathHandler = new CamelPathHandler(defaultHandler);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        this.pathHandler.handleRequest(exchange2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized HttpHandler add(String path, String methods, boolean prefixMatch, HttpHandler handler) {
        CamelMethodHandler targetHandler;
        String basePath = this.getBasePath(path);
        HttpHandler basePathHandler = this.pathHandler.getHandler(basePath);
        if (path.contains("{")) {
            String relativePath = path.substring(basePath.length());
            if (basePathHandler instanceof CamelPathTemplateHandler) {
                CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
                targetHandler = templateHandler.get(relativePath);
                if (targetHandler != null) return targetHandler.add(methods, handler);
                targetHandler = new CamelMethodHandler();
                templateHandler.add(relativePath, targetHandler);
                return targetHandler.add(methods, handler);
            } else {
                targetHandler = this.add(basePathHandler, relativePath, basePath);
            }
            return targetHandler.add(methods, handler);
        } else if (basePathHandler instanceof CamelPathTemplateHandler) {
            CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
            if (prefixMatch) throw new IllegalArgumentException(String.format("Duplicate handlers on a path '%s'", path));
            targetHandler = templateHandler.getDefault();
            return targetHandler.add(methods, handler);
        } else if (basePathHandler instanceof CamelMethodHandler) {
            targetHandler = (CamelMethodHandler)basePathHandler;
            return targetHandler.add(methods, handler);
        } else {
            if (basePathHandler != null) throw new IllegalArgumentException(String.format("Unsupported handler '%s' was found", basePathHandler));
            targetHandler = new CamelMethodHandler();
            if (prefixMatch) {
                this.pathHandler.addPrefixPath(basePath, targetHandler);
                return targetHandler.add(methods, handler);
            } else {
                this.pathHandler.addExactPath(basePath, targetHandler);
            }
        }
        return targetHandler.add(methods, handler);
    }

    private CamelMethodHandler add(HttpHandler basePathHandler, String relativePath, String basePath) {
        CamelPathTemplateHandler templateHandler;
        if (basePathHandler instanceof CamelMethodHandler) {
            templateHandler = new CamelPathTemplateHandler((CamelMethodHandler)basePathHandler);
        } else if (basePathHandler == null) {
            templateHandler = new CamelPathTemplateHandler(new CamelMethodHandler());
        } else {
            throw new IllegalArgumentException(String.format("Unsupported handler '%s' was found", basePathHandler));
        }
        CamelMethodHandler targetHandler = new CamelMethodHandler();
        templateHandler.add(relativePath, targetHandler);
        this.pathHandler.addPrefixPath(basePath, templateHandler);
        return targetHandler;
    }

    public synchronized void remove(String path, String methods, boolean prefixMatch) {
        String basePath = this.getBasePath(path);
        HttpHandler basePathHandler = this.pathHandler.getHandler(basePath);
        if (basePathHandler == null) {
            return;
        }
        if (path.contains("{")) {
            CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
            String relativePath = path.substring(basePath.length());
            CamelMethodHandler targetHandler = templateHandler.get(relativePath);
            if (targetHandler.remove(methods)) {
                templateHandler.remove(relativePath);
                if (templateHandler.isEmpty()) {
                    this.pathHandler.removePrefixPath(basePath);
                }
            }
        } else if (basePathHandler instanceof CamelPathTemplateHandler) {
            String relativePath = path.substring(basePath.length());
            CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
            CamelMethodHandler targetHandler = templateHandler.getDefault();
            if (targetHandler.remove(methods)) {
                templateHandler.remove(relativePath);
                if (templateHandler.isEmpty()) {
                    this.pathHandler.removePrefixPath(basePath);
                }
            }
        } else {
            CamelMethodHandler targetHandler = (CamelMethodHandler)basePathHandler;
            if (targetHandler.remove(methods)) {
                if (prefixMatch) {
                    this.pathHandler.removePrefixPath(basePath);
                } else {
                    this.pathHandler.removeExactPath(basePath);
                }
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.pathHandler.isEmpty();
    }

    public String toString() {
        return this.pathHandler.toString();
    }

    private String getBasePath(String path) {
        if (path.contains("{")) {
            path = PathTemplate.create(path).getBase();
        }
        return URLUtils.normalizeSlashes(path);
    }
}

