/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.TypeConverterSupport;

public class StaticMethodTypeConverter
extends TypeConverterSupport {
    private final Method method;
    private final boolean useExchange;
    private final boolean allowNull;

    public StaticMethodTypeConverter(Method method, boolean allowNull) {
        this.method = method;
        this.useExchange = method.getParameterCount() == 2;
        this.allowNull = allowNull;
    }

    public String toString() {
        return "StaticMethodTypeConverter: " + String.valueOf(this.method);
    }

    @Override
    public boolean allowNull() {
        return this.allowNull;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange2, Object value) {
        return (T)(this.useExchange ? ObjectHelper.invokeMethod(this.method, null, value, exchange2) : ObjectHelper.invokeMethod(this.method, null, value));
    }
}

