/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.spi.NormalizedEndpointUri;

final class ProcessorHelper {
    private ProcessorHelper() {
    }

    static Object prepareRecipient(Exchange exchange2, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            String string = (String)recipient;
            recipient = string.trim();
        }
        if (recipient != null) {
            String string;
            CamelContext ecc = exchange2.getContext();
            String uri = recipient instanceof String ? (string = (String)recipient) : ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange2, recipient);
            return ecc.getCamelContextExtension().normalizeUri(uri);
        }
        return null;
    }

    static Endpoint getExistingEndpoint(Exchange exchange2, Object recipient) {
        return ProcessorHelper.getExistingEndpoint(exchange2.getContext(), recipient);
    }

    static Endpoint getExistingEndpoint(CamelContext context, Object recipient) {
        if (recipient instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)recipient;
            return endpoint;
        }
        if (recipient != null) {
            if (recipient instanceof NormalizedEndpointUri) {
                NormalizedEndpointUri nu = (NormalizedEndpointUri)recipient;
                ExtendedCamelContext ecc = context.getCamelContextExtension();
                return ecc.hasEndpoint(nu);
            }
            String uri = recipient.toString();
            return context.hasEndpoint(uri);
        }
        return null;
    }
}

