/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import org.apache.camel.Exchange;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentOnCompletion
implements Synchronization {
    private static final Logger LOG = LoggerFactory.getLogger(IdempotentOnCompletion.class);
    private final IdempotentRepository idempotentRepository;
    private final String messageId;
    private final boolean eager;
    private final boolean removeOnFailure;

    public IdempotentOnCompletion(IdempotentRepository idempotentRepository, String messageId, boolean eager, boolean removeOnFailure) {
        this.idempotentRepository = idempotentRepository;
        this.messageId = messageId;
        this.eager = eager;
        this.removeOnFailure = removeOnFailure;
    }

    @Override
    public void onComplete(Exchange exchange2) {
        if (ExchangeHelper.isFailureHandled(exchange2)) {
            this.onFailedMessage(exchange2, this.messageId);
        } else {
            this.onCompletedMessage(exchange2, this.messageId);
        }
    }

    @Override
    public void onFailure(Exchange exchange2) {
        this.onFailedMessage(exchange2, this.messageId);
    }

    protected void onCompletedMessage(Exchange exchange2, String messageId) {
        if (!this.eager) {
            this.idempotentRepository.add(exchange2, messageId);
        }
        this.idempotentRepository.confirm(exchange2, messageId);
    }

    protected void onFailedMessage(Exchange exchange2, String messageId) {
        if (this.removeOnFailure) {
            this.idempotentRepository.remove(exchange2, messageId);
            LOG.debug("Removed from repository as exchange failed: {} with id: {}", (Object)exchange2, (Object)messageId);
        }
    }

    public String toString() {
        return "IdempotentOnCompletion[" + this.messageId + "]";
    }
}

