/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Ordered;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;

public interface BulkTypeConverters
extends Ordered,
TypeConverter {
    public TypeConverter lookup(Class<?> var1, Class<?> var2);

    public <T> T convertTo(Class<?> var1, Class<T> var2, Exchange var3, Object var4) throws TypeConversionException;

    default public <T> T tryConvertTo(Class<?> from, Class<T> to, Exchange exchange2, Object value) throws TypeConversionException {
        try {
            this.convertTo(from, to, exchange2, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    default public <T> T mandatoryConvertTo(Class<?> from, Class<T> to, Exchange exchange2, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        T t = this.convertTo(from, to, exchange2, value);
        if (t == null) {
            throw new NoTypeConversionAvailableException(value, to);
        }
        return t;
    }

    public int size();

    @Override
    default public int getOrder() {
        return 0;
    }

    @Override
    default public boolean allowNull() {
        return false;
    }

    @Override
    default public <T> T convertTo(Class<T> type, Object value) throws TypeConversionException {
        return this.convertTo(value.getClass(), type, null, value);
    }

    @Override
    default public <T> T convertTo(Class<T> type, Exchange exchange2, Object value) throws TypeConversionException {
        return this.convertTo(value.getClass(), type, exchange2, value);
    }

    @Override
    default public <T> T mandatoryConvertTo(Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(value.getClass(), type, null, value);
    }

    @Override
    default public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange2, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(value.getClass(), type, exchange2, value);
    }

    @Override
    default public <T> T tryConvertTo(Class<T> type, Object value) {
        return this.tryConvertTo(value.getClass(), type, null, value);
    }

    @Override
    default public <T> T tryConvertTo(Class<T> type, Exchange exchange2, Object value) {
        return this.tryConvertTo(value.getClass(), type, exchange2, value);
    }
}

