/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeExtension;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.VariableAware;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;

public final class ExchangeHelper {
    private static final String DEFAULT_CHARSET_NAME = ObjectHelper.getSystemProperty("org.apache.camel.default.charset", "UTF-8");
    private static final Charset DEFAULT_CHARSET = Charset.forName(DEFAULT_CHARSET_NAME);
    private static Exchange DUMMY;

    private ExchangeHelper() {
    }

    public static Exchange getDummy(CamelContext context) {
        if (DUMMY == null) {
            DUMMY = new DefaultExchange(context);
        }
        return DUMMY;
    }

    public static <T> T getBinding(Exchange exchange2, Class<T> type) {
        return exchange2 != null ? (T)exchange2.getProperty("CamelBinding", type) : null;
    }

    public static Endpoint resolveEndpoint(Exchange exchange2, Object value) throws NoSuchEndpointException {
        return ExchangeHelper.resolveEndpoint(exchange2.getContext(), value);
    }

    public static Endpoint resolveEndpoint(CamelContext context, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value == null) {
            throw new NoSuchEndpointException("null");
        }
        if (value instanceof Endpoint) {
            Endpoint ep;
            endpoint = ep = (Endpoint)value;
        } else if (value instanceof NormalizedEndpointUri) {
            NormalizedEndpointUri nu = (NormalizedEndpointUri)value;
            endpoint = CamelContextHelper.getMandatoryEndpoint(context, nu);
        } else {
            String uri = value.toString().trim();
            endpoint = CamelContextHelper.getMandatoryEndpoint(context, uri);
        }
        return endpoint;
    }

    public static Endpoint resolvePrototypeEndpoint(Exchange exchange2, Object value) throws NoSuchEndpointException {
        return ExchangeHelper.resolvePrototypeEndpoint(exchange2.getContext(), value);
    }

    public static Endpoint resolvePrototypeEndpoint(CamelContext context, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value == null) {
            throw new NoSuchEndpointException("null");
        }
        if (value instanceof Endpoint) {
            Endpoint ep;
            endpoint = ep = (Endpoint)value;
        } else if (value instanceof NormalizedEndpointUri) {
            NormalizedEndpointUri nu = (NormalizedEndpointUri)value;
            endpoint = CamelContextHelper.getMandatoryPrototypeEndpoint(context, nu);
        } else {
            String uri = value.toString().trim();
            endpoint = CamelContextHelper.getMandatoryPrototypeEndpoint(context, uri);
        }
        return endpoint;
    }

    public static <T> T getMandatoryProperty(Exchange exchange2, String propertyName, Class<T> type) throws NoSuchPropertyException {
        T result = exchange2.getProperty(propertyName, type);
        if (result != null) {
            return result;
        }
        throw new NoSuchPropertyException(exchange2, propertyName, type);
    }

    public static <T> T getMandatoryHeader(Exchange exchange2, String headerName, Class<T> type) throws TypeConversionException, NoSuchHeaderException {
        T answer = exchange2.getIn().getHeader(headerName, type);
        if (answer == null) {
            throw new NoSuchHeaderException(exchange2, headerName, type);
        }
        return answer;
    }

    public static <T> T getMandatoryHeader(Message message, String headerName, Class<T> type) throws TypeConversionException, NoSuchHeaderException {
        T answer = message.getHeader(headerName, type);
        if (answer == null) {
            throw new NoSuchHeaderException(message.getExchange(), headerName, type);
        }
        return answer;
    }

    public static <T> T getHeaderOrProperty(Exchange exchange2, String name, Class<T> type) throws TypeConversionException {
        T answer = exchange2.getIn().getHeader(name, type);
        if (answer == null) {
            answer = exchange2.getProperty(name, type);
        }
        return answer;
    }

    public static <T> T convertToMandatoryType(Exchange exchange2, Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        return exchange2.getContext().getTypeConverter().mandatoryConvertTo(type, exchange2, value);
    }

    public static <T> T convertToType(Exchange exchange2, Class<T> type, Object value) throws TypeConversionException {
        return exchange2.getContext().getTypeConverter().convertTo(type, exchange2, value);
    }

    public static Exchange createCorrelatedCopy(Exchange exchange2, boolean handover) {
        return ExchangeHelper.createCorrelatedCopy(exchange2, handover, false);
    }

    public static Exchange createCorrelatedCopy(Exchange exchange2, boolean handover, boolean useSameMessageId) {
        String id = exchange2.getExchangeId();
        Exchange copy = exchange2.copy();
        if (!useSameMessageId) {
            if (copy.hasOut()) {
                copy.getOut().setMessageId(null);
            }
            copy.getIn().setMessageId(null);
        }
        copy.getExchangeExtension().setUnitOfWork(null);
        if (handover) {
            exchange2.getExchangeExtension().handoverCompletions(copy);
        }
        copy.setProperty(ExchangePropertyKey.CORRELATION_ID, (Object)id);
        return copy;
    }

    public static Exchange createCopy(Exchange exchange2, boolean preserveExchangeId) {
        Exchange copy = exchange2.copy();
        if (preserveExchangeId) {
            copy.setExchangeId(exchange2.getExchangeId());
        }
        return copy;
    }

    public static void copyResults(Exchange target, Exchange source) {
        ExchangeHelper.doCopyResults(target, source, false);
    }

    public static void copyResultsPreservePattern(Exchange target, Exchange source) {
        ExchangeHelper.doCopyResults(target, source, true);
    }

    private static void doCopyResults(Exchange result, Exchange source, boolean preserverPattern) {
        if (result == source) {
            ExchangeHelper.copyFromOutMessageConditionally(result, source);
            return;
        }
        if (source.hasOut()) {
            ExchangeHelper.copyFromOutMessage(result, source, preserverPattern);
        } else {
            ExchangeHelper.copyFromInMessage(result, source, preserverPattern);
        }
        if (source.hasProperties()) {
            result.getProperties().putAll(source.getProperties());
        }
        ExchangeExtension sourceExtension = source.getExchangeExtension();
        sourceExtension.copyInternalProperties(result);
        ExchangeExtension resultExtension = result.getExchangeExtension();
        sourceExtension.copySafeCopyPropertiesTo(resultExtension);
        result.setRouteStop(source.isRouteStop());
        result.setRollbackOnly(source.isRollbackOnly());
        result.setRollbackOnlyLast(source.isRollbackOnlyLast());
        resultExtension.setNotifyEvent(sourceExtension.isNotifyEvent());
        resultExtension.setRedeliveryExhausted(sourceExtension.isRedeliveryExhausted());
        resultExtension.setErrorHandlerHandled(sourceExtension.getErrorHandlerHandled());
        resultExtension.setFailureHandled(sourceExtension.isFailureHandled());
        result.setException(source.getException());
    }

    private static void copyFromOutMessageConditionally(Exchange result, Exchange source) {
        if (result.getPattern().isOutCapable() && !result.hasOut() && !result.isFailed()) {
            result.getOut().copyFrom(source.getIn());
        }
    }

    private static void copyFromInMessage(Exchange result, Exchange source, boolean preserverPattern) {
        if (!preserverPattern && result.getPattern().isOutCapable()) {
            result.getOut().copyFrom(source.getIn());
        } else {
            result.getIn().copyFrom(source.getIn());
            if (result.hasOut()) {
                result.setOut(null);
            }
        }
    }

    private static void copyFromOutMessage(Exchange result, Exchange source, boolean preserverPattern) {
        if (preserverPattern) {
            Message resultMessage = ExchangeHelper.getResultMessage(result);
            resultMessage.copyFrom(source.getOut());
        } else {
            result.getOut().copyFrom(source.getOut());
        }
    }

    public static Message getResultMessage(Exchange exchange2) {
        if (exchange2.getPattern().isOutCapable()) {
            return exchange2.getOut();
        }
        return exchange2.getIn();
    }

    public static boolean isOutCapable(Exchange exchange2) {
        ExchangePattern pattern = exchange2.getPattern();
        return pattern != null && pattern.isOutCapable();
    }

    public static <T> T newInstance(Exchange exchange2, Class<T> type) {
        return exchange2.getContext().getInjector().newInstance(type);
    }

    public static Map<String, Object> createVariableMap(Exchange exchange2, boolean allowContextMapAll) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        ExchangeHelper.populateVariableMap(exchange2, answer, allowContextMapAll);
        return answer;
    }

    public static void populateVariableMap(Exchange exchange2, Map<String, Object> map, boolean allowContextMapAll) {
        Message in = exchange2.getIn();
        map.put("headers", in.getHeaders());
        map.put("body", in.getBody());
        map.put("variables", exchange2.getVariables());
        if (allowContextMapAll) {
            map.put("in", in);
            map.put("request", in);
            map.put("exchange", exchange2);
            map.put("exchangeProperties", exchange2.getAllProperties());
            if (ExchangeHelper.isOutCapable(exchange2)) {
                Message msg = exchange2.getMessage();
                map.put("out", msg);
                map.put("response", msg);
            }
            map.put("camelContext", exchange2.getContext());
        }
    }

    public static String getContentType(Exchange exchange2) {
        return MessageHelper.getContentType(exchange2.getIn());
    }

    public static String getContentEncoding(Exchange exchange2) {
        return MessageHelper.getContentEncoding(exchange2.getIn());
    }

    public static Object lookupMandatoryBean(Exchange exchange2, String name) throws NoSuchBeanException {
        Object value = ExchangeHelper.lookupBean(exchange2, name);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static <T> T lookupMandatoryBean(Exchange exchange2, String name, Class<T> type) {
        T value = ExchangeHelper.lookupBean(exchange2, name, type);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static Object lookupBean(Exchange exchange2, String name) {
        return exchange2.getContext().getRegistry().lookupByName(name);
    }

    public static <T> T lookupBean(Exchange exchange2, String name, Class<T> type) {
        return exchange2.getContext().getRegistry().lookupByNameAndType(name, type);
    }

    public static void prepareAggregation(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange != null) {
            ExchangeHelper.prepareOutToIn(oldExchange);
        }
        if (newExchange != null) {
            ExchangeHelper.prepareOutToIn(newExchange);
        }
    }

    public static boolean isFailureHandled(Exchange exchange2) {
        return exchange2.getExchangeExtension().isFailureHandled();
    }

    public static boolean isErrorHandlerBridge(Exchange exchange2) {
        return exchange2.getProperty(ExchangePropertyKey.ERRORHANDLER_BRIDGE, (Object)false, Boolean.class);
    }

    public static boolean isUnitOfWorkExhausted(Exchange exchange2) {
        return exchange2.getProperty(ExchangePropertyKey.UNIT_OF_WORK_EXHAUSTED, (Object)false, Boolean.class);
    }

    public static void setFailureHandled(Exchange exchange2) {
        exchange2.setException(null);
        exchange2.getExchangeExtension().setFailureHandled(true);
    }

    public static boolean isRedelivered(Exchange exchange2) {
        return exchange2.getIn().hasHeaders() && exchange2.getIn().getHeader("CamelRedelivered", false, Boolean.class) != false;
    }

    public static boolean isStreamCachingEnabled(Exchange exchange2) {
        Route route = exchange2.getContext().getRoute(exchange2.getFromRouteId());
        if (route != null) {
            return route.isStreamCaching();
        }
        return exchange2.getContext().getStreamCachingStrategy().isEnabled();
    }

    public static Object extractResultBody(Exchange exchange2, ExchangePattern pattern) {
        Object answer = null;
        if (exchange2 != null) {
            if (exchange2.getException() != null) {
                throw CamelExecutionException.wrapCamelExecutionException(exchange2, exchange2.getException());
            }
            boolean notOut = pattern != null && !pattern.isOutCapable();
            boolean hasOut = exchange2.hasOut();
            answer = hasOut && !notOut ? exchange2.getOut().getBody() : exchange2.getIn().getBody();
            if (exchange2.getException() != null) {
                throw CamelExecutionException.wrapCamelExecutionException(exchange2, exchange2.getException());
            }
        }
        return answer;
    }

    public static <T> T extractFutureBody(CamelContext context, Future<?> future, Class<T> type) {
        try {
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        catch (ExecutionException e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    public static <T> T extractFutureBody(CamelContext context, Future<?> future, long timeout, TimeUnit unit, Class<T> type) throws TimeoutException {
        try {
            if (timeout > 0L) {
                T t = ExchangeHelper.doExtractFutureBody(context, future.get(timeout, unit), type);
                return t;
            }
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw CamelExecutionException.wrapCamelExecutionException(null, e);
        }
        catch (ExecutionException e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    private static <T> T doExtractFutureBody(CamelContext context, Object result, Class<T> type) {
        if (result == null) {
            return null;
        }
        if (type.isAssignableFrom(result.getClass())) {
            return type.cast(result);
        }
        if (result instanceof Exchange) {
            Exchange exchange2 = (Exchange)result;
            Object answer = ExchangeHelper.extractResultBody(exchange2, exchange2.getPattern());
            return context.getTypeConverter().convertTo(type, exchange2, answer);
        }
        return context.getTypeConverter().convertTo(type, result);
    }

    public static void prepareOutToIn(Exchange exchange2) {
        if (exchange2.hasOut()) {
            exchange2.setIn(exchange2.getOut());
            exchange2.setOut(null);
        }
    }

    public static String logIds(Exchange exchange2) {
        String msgId = exchange2.getMessage().getMessageId();
        return "(MessageId: " + msgId + " on ExchangeId: " + exchange2.getExchangeId() + ")";
    }

    private static void setMessageHistory(Exchange target, Exchange source) {
        Object history = source.getProperty(ExchangePropertyKey.MESSAGE_HISTORY);
        if (history != null) {
            target.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, new CopyOnWriteArrayList((List)history));
        }
    }

    public static Exchange copyExchangeWithProperties(Exchange exchange2, CamelContext context) {
        Exchange answer = exchange2.getExchangeExtension().createCopyWithProperties(context);
        ExchangeHelper.setMessageHistory(answer, exchange2);
        answer.setIn(exchange2.getIn().copy());
        if (exchange2.hasOut()) {
            answer.setOut(exchange2.getOut().copy());
        }
        answer.setException(exchange2.getException());
        return answer;
    }

    public static void replaceMessage(Exchange exchange2, Message newMessage, boolean outOnly) {
        Message old = exchange2.getMessage();
        if (outOnly || exchange2.hasOut()) {
            exchange2.setOut(newMessage);
        } else {
            exchange2.setIn(newMessage);
        }
        if (old instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)old;
            messageSupport.setExchange(null);
        }
    }

    public static Message getOriginalInMessage(Exchange exchange2) {
        Message answer = null;
        UnitOfWork uow = exchange2.getProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, UnitOfWork.class);
        if (uow != null) {
            answer = uow.getOriginalInMessage();
        }
        if (answer == null && (uow = exchange2.getUnitOfWork()) != null) {
            answer = uow.getOriginalInMessage();
        }
        return answer;
    }

    public static String resolveScheme(String uri) {
        return StringHelper.before(uri, ":");
    }

    public static String getCharsetName(Exchange exchange2) {
        return ExchangeHelper.getCharsetName(exchange2, true);
    }

    public static Charset getCharset(Exchange exchange2) {
        return ExchangeHelper.getCharset(exchange2, true);
    }

    public static String getCharsetName(Exchange exchange2, boolean useDefault) {
        if (exchange2 != null) {
            String charsetName = exchange2.getIn().getHeader("CamelCharsetName", String.class);
            if (charsetName == null) {
                charsetName = exchange2.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            }
            if (charsetName != null) {
                return IOHelper.normalizeCharset(charsetName);
            }
        }
        if (useDefault) {
            return ExchangeHelper.getDefaultCharsetName();
        }
        return null;
    }

    public static Charset getCharset(Exchange exchange2, boolean useDefault) {
        if (exchange2 != null) {
            String charsetName = exchange2.getIn().getHeader("CamelCharsetName", String.class);
            if (charsetName == null) {
                charsetName = exchange2.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            }
            if (charsetName != null) {
                charsetName = IOHelper.normalizeCharset(charsetName);
                return Charset.forName(charsetName);
            }
        }
        if (useDefault) {
            return ExchangeHelper.getDefaultCharset();
        }
        return null;
    }

    private static String getDefaultCharsetName() {
        return DEFAULT_CHARSET_NAME;
    }

    private static Charset getDefaultCharset() {
        return DEFAULT_CHARSET;
    }

    public static Scanner getScanner(Exchange exchange2, Object value, String delimiter) {
        Scanner scanner;
        if (value instanceof WrappedFile) {
            WrappedFile gf = (WrappedFile)value;
            Object body2 = gf.getBody();
            value = body2 != null ? body2 : gf.getFile();
        }
        if (value instanceof Readable) {
            Readable readable = (Readable)value;
            scanner = new Scanner(readable, delimiter);
        } else if (value instanceof String) {
            String str = (String)value;
            scanner = new Scanner(str, delimiter);
        } else {
            String charset = exchange2.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            if (value instanceof Path) {
                Path path = (Path)value;
                try {
                    scanner = new Scanner(Files.newByteChannel(path, StandardOpenOption.READ), charset, delimiter);
                }
                catch (IOException e) {
                    throw new RuntimeCamelException(e);
                }
            } else if (value instanceof File) {
                File file = (File)value;
                try {
                    scanner = new Scanner(file, charset, delimiter);
                }
                catch (IOException e) {
                    throw new RuntimeCamelException(e);
                }
            } else if (value instanceof InputStream) {
                InputStream inputStream = (InputStream)value;
                scanner = new Scanner(inputStream, charset, delimiter);
            } else if (value instanceof ReadableByteChannel) {
                ReadableByteChannel readableByteChannel = (ReadableByteChannel)value;
                scanner = new Scanner(readableByteChannel, charset, delimiter);
            } else {
                String text = exchange2.getContext().getTypeConverter().convertTo(String.class, exchange2, value);
                scanner = new Scanner(text, delimiter);
            }
        }
        return scanner;
    }

    public static String getRouteId(Exchange exchange2) {
        String answer = ExchangeHelper.getAtRouteId(exchange2);
        if (answer == null) {
            answer = exchange2.getFromRouteId();
        }
        return answer;
    }

    public static String getAtRouteId(Exchange exchange2) {
        String answer = null;
        Route rc = ExchangeHelper.getRoute(exchange2);
        if (rc != null) {
            answer = rc.getRouteId();
        }
        return answer;
    }

    public static String getRouteGroup(Exchange exchange2) {
        Route rc = ExchangeHelper.getRoute(exchange2);
        if (rc != null) {
            return rc.getGroup();
        }
        return null;
    }

    public static Route getRoute(Exchange exchange2) {
        UnitOfWork uow = exchange2.getUnitOfWork();
        return uow != null ? uow.getRoute() : null;
    }

    public static void setInOutBodyPatternAware(Exchange exchange2, Object body2) {
        if (exchange2.getPattern().isOutCapable()) {
            exchange2.getOut().copyFrom(exchange2.getIn());
            exchange2.getOut().setBody(body2);
        } else {
            exchange2.getIn().setBody(body2);
        }
    }

    public static void setOutBodyPatternAware(Exchange exchange2, Object body2) {
        if (exchange2.getPattern().isOutCapable()) {
            exchange2.getOut().copyFrom(exchange2.getIn());
            exchange2.getOut().setBody(body2);
        }
    }

    public static void setVariable(Exchange exchange2, String name, Object value) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(exchange2, id);
            name = ExchangeHelper.resolveVariableRepositoryName(exchange2, name, id);
        }
        VariableAware va = ExchangeHelper.getVariableAware(exchange2, repo);
        va.setVariable(name, value);
    }

    public static String getVariableRepositoryId(String name) {
        String id = StringHelper.before(name, ":");
        if (ExchangeHelper.isReserved(id)) {
            id = null;
        }
        return id;
    }

    public static String resolveVariableRepositoryName(Exchange exchange2, String name, String id) {
        name = StringHelper.after((String)name, ":");
        if ("route".equals(id) && !((String)name).contains(":")) {
            String prefix = ExchangeHelper.getAtRouteId(exchange2);
            if (prefix != null) {
                name = prefix + ":" + (String)name;
            } else {
                return null;
            }
        }
        return name;
    }

    public static void setVariableFromMessageBodyAndHeaders(Exchange exchange2, String name, Message message) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(exchange2, id);
            name = ExchangeHelper.resolveVariableRepositoryName(exchange2, name, id);
        }
        VariableAware va = ExchangeHelper.getVariableAware(exchange2, repo);
        Object body2 = message.getBody();
        va.setVariable(name, body2);
        for (Map.Entry<String, Object> header : message.getHeaders().entrySet()) {
            String key = "header:" + name + "." + header.getKey();
            Object value = header.getValue();
            va.setVariable(key, value);
        }
    }

    public static boolean shouldSetVariableResult(Exchange exchange2, String name) {
        boolean stop;
        if (name == null) {
            return false;
        }
        boolean bl = stop = exchange2.isRouteStop() || exchange2.isFailed() || exchange2.isRollbackOnly() || exchange2.isRollbackOnlyLast() || exchange2.getExchangeExtension().isErrorHandlerHandledSet() && exchange2.getExchangeExtension().isErrorHandlerHandled();
        return !stop;
    }

    public static Object getVariable(Exchange exchange2, String name) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(exchange2, id);
            name = ExchangeHelper.resolveVariableRepositoryName(exchange2, name, id);
        }
        VariableAware va = ExchangeHelper.getVariableAware(exchange2, repo);
        return va.getVariable(name);
    }

    public static VariableRepository getVariableRepository(Exchange exchange2, String id) {
        VariableRepositoryFactory factory = exchange2.getContext().getCamelContextExtension().getContextPlugin(VariableRepositoryFactory.class);
        VariableRepository repo = factory.getVariableRepository(id);
        if (repo == null) {
            throw new IllegalArgumentException("VariableRepository with id: " + id + " does not exist");
        }
        return repo;
    }

    private static boolean isReserved(String id) {
        return "header".equals(id) || "exchange".equals(id);
    }

    private static VariableAware getVariableAware(Exchange exchange2, VariableRepository repo) {
        VariableAware va = repo != null ? repo : exchange2;
        return va;
    }

    public static <T> T getVariable(Exchange exchange2, String name, Class<T> type) {
        Object answer = ExchangeHelper.getVariable(exchange2, name);
        if (answer != null) {
            return exchange2.getContext().getTypeConverter().convertTo(type, exchange2, answer);
        }
        return null;
    }

    public static <T> T getBodyAndResetStreamCache(Exchange exchange2, Class<T> type) {
        Object body2 = exchange2.getMessage().getBody();
        if (body2 instanceof StreamCache) {
            StreamCache sc = (StreamCache)body2;
            sc.reset();
        }
        return exchange2.getMessage().getBody(type);
    }
}

