/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderOrPropertyException;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class ConvertHeaderProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final String name;
    private final Expression headerName;
    private final String toName;
    private final Expression toHeaderName;
    private final Class<?> type;
    private final String charset;
    private final boolean mandatory;

    public ConvertHeaderProcessor(String name, Expression headerName, String toName, Expression toHeaderName, Class<?> type, String charset, boolean mandatory) {
        ObjectHelper.notNull(headerName, "headerName");
        ObjectHelper.notNull(type, "type", this);
        this.name = name;
        this.headerName = headerName;
        this.toName = toName;
        this.toHeaderName = toHeaderName;
        this.type = type;
        this.charset = IOHelper.normalizeCharset(charset);
        this.mandatory = mandatory;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public void process(Exchange exchange2) throws Exception {
        Object value;
        String targetName;
        Message old = exchange2.getMessage();
        String name = this.headerName.evaluate(exchange2, String.class);
        String string = targetName = this.toHeaderName != null ? this.toHeaderName.evaluate(exchange2, String.class) : name;
        if (old.getHeader(name) == null) {
            return;
        }
        if (exchange2.getException() != null) {
            return;
        }
        String originalCharsetName = null;
        if (this.charset != null) {
            originalCharsetName = exchange2.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            exchange2.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)this.charset);
        }
        if ((value = old.getHeader(name)) == null && this.mandatory) {
            throw new NoSuchHeaderOrPropertyException(exchange2, name, null, this.type);
        }
        value = this.mandatory ? exchange2.getContext().getTypeConverter().mandatoryConvertTo(this.type, exchange2, value) : exchange2.getContext().getTypeConverter().convertTo(this.type, exchange2, value);
        old.setHeader(targetName, value);
        if (this.charset != null) {
            if (originalCharsetName != null && !originalCharsetName.isEmpty()) {
                exchange2.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)originalCharsetName);
            } else {
                exchange2.removeProperty(ExchangePropertyKey.CHARSET_NAME);
            }
        }
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange2) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange2);
        this.process(exchange2, callback);
        return callback.getFuture();
    }

    @Override
    public boolean process(Exchange exchange2, AsyncCallback callback) {
        try {
            this.process(exchange2);
        }
        catch (Exception e) {
            exchange2.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getToName() {
        return this.toName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getCharset() {
        return this.charset;
    }
}

