/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractTraceInterceptor
implements MethodInterceptor,
Serializable {
    @Nullable
    protected transient Log defaultLogger = LogFactory.getLog(this.getClass());
    private boolean hideProxyClassNames = false;
    private boolean logExceptionStackTrace = true;

    public void setUseDynamicLogger(boolean useDynamicLogger) {
        this.defaultLogger = useDynamicLogger ? null : LogFactory.getLog(this.getClass());
    }

    public void setLoggerName(String loggerName) {
        this.defaultLogger = LogFactory.getLog(loggerName);
    }

    public void setHideProxyClassNames(boolean hideProxyClassNames) {
        this.hideProxyClassNames = hideProxyClassNames;
    }

    public void setLogExceptionStackTrace(boolean logExceptionStackTrace) {
        this.logExceptionStackTrace = logExceptionStackTrace;
    }

    @Override
    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Log logger2 = this.getLoggerForInvocation(invocation);
        if (this.isInterceptorEnabled(invocation, logger2)) {
            return this.invokeUnderTrace(invocation, logger2);
        }
        return invocation.proceed();
    }

    protected Log getLoggerForInvocation(MethodInvocation invocation) {
        if (this.defaultLogger != null) {
            return this.defaultLogger;
        }
        Object target = invocation.getThis();
        Assert.state(target != null, "Target must not be null");
        return LogFactory.getLog(this.getClassForLogging(target));
    }

    protected Class<?> getClassForLogging(Object target) {
        return this.hideProxyClassNames ? AopUtils.getTargetClass(target) : target.getClass();
    }

    protected boolean isInterceptorEnabled(MethodInvocation invocation, Log logger2) {
        return this.isLogEnabled(logger2);
    }

    protected boolean isLogEnabled(Log logger2) {
        return logger2.isTraceEnabled();
    }

    protected void writeToLog(Log logger2, String message) {
        this.writeToLog(logger2, message, null);
    }

    protected void writeToLog(Log logger2, String message, @Nullable Throwable ex) {
        if (ex != null && this.logExceptionStackTrace) {
            logger2.trace(message, ex);
        } else {
            logger2.trace(message);
        }
    }

    @Nullable
    protected abstract Object invokeUnderTrace(MethodInvocation var1, Log var2) throws Throwable;
}

