/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.support.AbstractResourceBasedMessageSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ResourceBundleMessageSource
extends AbstractResourceBasedMessageSource
implements BeanClassLoaderAware {
    @Nullable
    private ClassLoader bundleClassLoader;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Map<String, Map<Locale, ResourceBundle>> cachedResourceBundles = new ConcurrentHashMap<String, Map<Locale, ResourceBundle>>();
    private final Map<ResourceBundle, Map<String, Map<Locale, MessageFormat>>> cachedBundleMessageFormats = new ConcurrentHashMap<ResourceBundle, Map<String, Map<Locale, MessageFormat>>>();
    @Nullable
    private volatile MessageSourceControl control = new MessageSourceControl();

    public ResourceBundleMessageSource() {
        this.setDefaultEncoding("ISO-8859-1");
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    @Nullable
    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader != null ? this.bundleClassLoader : this.beanClassLoader;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    @Nullable
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        Set<String> basenames = this.getBasenameSet();
        for (String basename : basenames) {
            String result;
            ResourceBundle bundle2 = this.getResourceBundle(basename, locale);
            if (bundle2 == null || (result = this.getStringOrNull(bundle2, code)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    protected MessageFormat resolveCode(String code, Locale locale) {
        Set<String> basenames = this.getBasenameSet();
        for (String basename : basenames) {
            MessageFormat messageFormat;
            ResourceBundle bundle2 = this.getResourceBundle(basename, locale);
            if (bundle2 == null || (messageFormat = this.getMessageFormat(bundle2, code, locale)) == null) continue;
            return messageFormat;
        }
        return null;
    }

    @Nullable
    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        ResourceBundle bundle2;
        if (this.getCacheMillis() >= 0L) {
            return this.doGetBundle(basename, locale);
        }
        Map localeMap = this.cachedResourceBundles.get(basename);
        if (localeMap != null && (bundle2 = localeMap.get(locale)) != null) {
            return bundle2;
        }
        try {
            bundle2 = this.doGetBundle(basename, locale);
            if (localeMap == null) {
                localeMap = this.cachedResourceBundles.computeIfAbsent(basename, bn -> new ConcurrentHashMap());
            }
            localeMap.put((Locale)locale, (ResourceBundle)bundle2);
            return bundle2;
        }
        catch (MissingResourceException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage());
            }
            return null;
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        ClassLoader classLoader;
        block3: {
            classLoader = this.getBundleClassLoader();
            Assert.state(classLoader != null, "No bundle ClassLoader set");
            MessageSourceControl control = this.control;
            if (control != null) {
                try {
                    return ResourceBundle.getBundle(basename, locale, classLoader, control);
                }
                catch (UnsupportedOperationException ex) {
                    this.control = null;
                    String encoding = this.getDefaultEncoding();
                    if (encoding == null || !this.logger.isInfoEnabled()) break block3;
                    this.logger.info("ResourceBundleMessageSource is configured to read resources with encoding '" + encoding + "' but ResourceBundle.Control is not supported in current system environment: " + ex.getMessage() + " - falling back to plain ResourceBundle.getBundle retrieval with the platform default encoding. Consider setting the 'defaultEncoding' property to 'null' for participating in the platform default and therefore avoiding this log message.");
                }
            }
        }
        return ResourceBundle.getBundle(basename, locale, classLoader);
    }

    protected ResourceBundle loadBundle(Reader reader) throws IOException {
        return new PropertyResourceBundle(reader);
    }

    protected ResourceBundle loadBundle(InputStream inputStream) throws IOException {
        return new PropertyResourceBundle(inputStream);
    }

    @Nullable
    protected MessageFormat getMessageFormat(ResourceBundle bundle2, String code, Locale locale) throws MissingResourceException {
        MessageFormat result;
        Map codeMap = this.cachedBundleMessageFormats.get(bundle2);
        Map localeMap = null;
        if (codeMap != null && (localeMap = codeMap.get(code)) != null && (result = localeMap.get(locale)) != null) {
            return result;
        }
        String msg = this.getStringOrNull(bundle2, code);
        if (msg != null) {
            if (codeMap == null) {
                codeMap = this.cachedBundleMessageFormats.computeIfAbsent(bundle2, b -> new ConcurrentHashMap());
            }
            if (localeMap == null) {
                localeMap = codeMap.computeIfAbsent((String)code, c -> new ConcurrentHashMap());
            }
            MessageFormat result2 = this.createMessageFormat(msg, locale);
            localeMap.put(locale, result2);
            return result2;
        }
        return null;
    }

    @Nullable
    protected String getStringOrNull(ResourceBundle bundle2, String key) {
        if (bundle2.containsKey(key)) {
            try {
                return bundle2.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=" + String.valueOf(this.getBasenameSet());
    }

    private class MessageSourceControl
    extends ResourceBundle.Control {
        private MessageSourceControl() {
        }

        @Override
        @Nullable
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (format.equals("java.properties")) {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                ClassLoader classLoader = loader;
                boolean reloadFlag = reload;
                InputStream inputStream = null;
                if (reloadFlag) {
                    URLConnection connection;
                    URL url = classLoader.getResource(resourceName);
                    if (url != null && (connection = url.openConnection()) != null) {
                        connection.setUseCaches(false);
                        inputStream = connection.getInputStream();
                    }
                } else {
                    inputStream = classLoader.getResourceAsStream(resourceName);
                }
                if (inputStream != null) {
                    String encoding = ResourceBundleMessageSource.this.getDefaultEncoding();
                    if (encoding != null) {
                        try (InputStreamReader bundleReader = new InputStreamReader(inputStream, encoding);){
                            ResourceBundle resourceBundle = ResourceBundleMessageSource.this.loadBundle(bundleReader);
                            return resourceBundle;
                        }
                    }
                    try (InputStream bundleStream = inputStream;){
                        ResourceBundle resourceBundle = ResourceBundleMessageSource.this.loadBundle(bundleStream);
                        return resourceBundle;
                    }
                }
                return null;
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }

        @Override
        @Nullable
        public Locale getFallbackLocale(String baseName, Locale locale) {
            Locale defaultLocale = ResourceBundleMessageSource.this.getDefaultLocale();
            return defaultLocale != null && !defaultLocale.equals(locale) ? defaultLocale : null;
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            long cacheMillis = ResourceBundleMessageSource.this.getCacheMillis();
            return cacheMillis >= 0L ? cacheMillis : super.getTimeToLive(baseName, locale);
        }

        @Override
        public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle2, long loadTime) {
            if (super.needsReload(baseName, locale, format, loader, bundle2, loadTime)) {
                ResourceBundleMessageSource.this.cachedBundleMessageFormats.remove(bundle2);
                return true;
            }
            return false;
        }
    }
}

