/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.springframework.aop.Pointcut;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationInterceptorsOrder;
import org.springframework.security.authorization.method.AuthorizationMethodPointcuts;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PreAuthorizeReactiveAuthorizationManager;
import org.springframework.security.authorization.method.ReactiveAuthenticationUtils;
import org.springframework.security.authorization.method.ReactiveMethodInvocationUtils;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AuthorizationManagerBeforeReactiveMethodInterceptor
implements AuthorizationAdvisor {
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private static final int RETURN_TYPE_METHOD_PARAMETER_INDEX = -1;
    private final Pointcut pointcut;
    private final ReactiveAuthorizationManager<MethodInvocation> authorizationManager;
    private int order = AuthorizationInterceptorsOrder.FIRST.getOrder();
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();

    public static AuthorizationManagerBeforeReactiveMethodInterceptor preAuthorize() {
        return AuthorizationManagerBeforeReactiveMethodInterceptor.preAuthorize(new PreAuthorizeReactiveAuthorizationManager());
    }

    public static AuthorizationManagerBeforeReactiveMethodInterceptor preAuthorize(ReactiveAuthorizationManager<MethodInvocation> authorizationManager) {
        AuthorizationManagerBeforeReactiveMethodInterceptor interceptor = new AuthorizationManagerBeforeReactiveMethodInterceptor(AuthorizationMethodPointcuts.forAnnotations(PreAuthorize.class), authorizationManager);
        interceptor.setOrder(AuthorizationInterceptorsOrder.PRE_AUTHORIZE.getOrder());
        return interceptor;
    }

    public AuthorizationManagerBeforeReactiveMethodInterceptor(Pointcut pointcut, ReactiveAuthorizationManager<MethodInvocation> authorizationManager) {
        Assert.notNull((Object)pointcut, "pointcut cannot be null");
        Assert.notNull(authorizationManager, "authorizationManager cannot be null");
        this.pointcut = pointcut;
        this.authorizationManager = authorizationManager;
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        Class<?> type = method.getReturnType();
        boolean isSuspendingFunction = KotlinDetector.isSuspendingFunction(method);
        boolean hasFlowReturnType = COROUTINES_FLOW_CLASS_NAME.equals(new MethodParameter(method, -1).getParameterType().getName());
        boolean hasReactiveReturnType = Publisher.class.isAssignableFrom(type) || isSuspendingFunction || hasFlowReturnType;
        Assert.state(hasReactiveReturnType, () -> "The returnType " + type + " on " + method + " must return an instance of org.reactivestreams.Publisher (for example, a Mono or Flux) or the function must be a Kotlin coroutine in order to support Reactor Context");
        ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(type);
        if (hasFlowReturnType) {
            if (isSuspendingFunction) {
                return this.preAuthorized(mi, (Flux<Object>)Flux.defer(() -> (Publisher)ReactiveMethodInvocationUtils.proceed(mi)));
            }
            Assert.state(adapter != null, () -> "The returnType " + type + " on " + method + " must have a org.springframework.core.ReactiveAdapter registered");
            Flux<Object> response = this.preAuthorized(mi, (Flux<Object>)Flux.defer(() -> adapter.toPublisher(ReactiveMethodInvocationUtils.proceed(mi))));
            return KotlinDelegate.asFlow(response);
        }
        if (this.isMultiValue(type, adapter)) {
            Flux<Object> result = this.preAuthorized(mi, (Flux<Object>)Flux.defer(() -> (Publisher)ReactiveMethodInvocationUtils.proceed(mi)));
            return adapter != null ? adapter.fromPublisher((Publisher<?>)result) : result;
        }
        Mono<Object> result = this.preAuthorized(mi, (Mono<Object>)Mono.defer(() -> (Mono)ReactiveMethodInvocationUtils.proceed(mi)));
        return adapter != null ? adapter.fromPublisher((Publisher<?>)result) : result;
    }

    private Flux<Object> preAuthorized(MethodInvocation mi, Flux<Object> mapping) {
        Mono<Authentication> authentication = ReactiveAuthenticationUtils.getAuthentication();
        return this.authorizationManager.check(authentication, mi).switchIfEmpty(Mono.just((Object)new AuthorizationDecision(false))).flatMapMany(decision -> {
            if (decision.isGranted()) {
                return mapping.onErrorResume(AuthorizationDeniedException.class, deniedEx -> this.postProcess((AuthorizationResult)deniedEx, mi));
            }
            return this.postProcess((AuthorizationResult)decision, mi);
        });
    }

    private Mono<Object> preAuthorized(MethodInvocation mi, Mono<Object> mapping) {
        Mono<Authentication> authentication = ReactiveAuthenticationUtils.getAuthentication();
        return this.authorizationManager.check(authentication, mi).switchIfEmpty(Mono.just((Object)new AuthorizationDecision(false))).flatMap(decision -> {
            if (decision.isGranted()) {
                return mapping.onErrorResume(AuthorizationDeniedException.class, deniedEx -> this.postProcess((AuthorizationResult)deniedEx, mi));
            }
            return this.postProcess((AuthorizationResult)decision, mi);
        });
    }

    private Mono<Object> postProcess(AuthorizationResult decision, MethodInvocation mi) {
        return Mono.fromSupplier(() -> {
            ReactiveAuthorizationManager<MethodInvocation> patt7466$temp = this.authorizationManager;
            if (patt7466$temp instanceof MethodAuthorizationDeniedHandler) {
                MethodAuthorizationDeniedHandler handler = (MethodAuthorizationDeniedHandler)((Object)patt7466$temp);
                return handler.handleDeniedInvocation(mi, decision);
            }
            return this.defaultHandler.handleDeniedInvocation(mi, decision);
        }).flatMap(result -> {
            if (Mono.class.isAssignableFrom(result.getClass())) {
                return (Mono)result;
            }
            return Mono.justOrEmpty((Object)result);
        });
    }

    private boolean isMultiValue(Class<?> returnType, ReactiveAdapter adapter) {
        if (Flux.class.isAssignableFrom(returnType)) {
            return true;
        }
        return adapter != null && adapter.isMultiValue();
    }

    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }

    @Override
    public Advice getAdvice() {
        return this;
    }

    @Override
    public boolean isPerInstance() {
        return true;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        private static Object asFlow(Publisher<?> publisher) {
            return ReactiveFlowKt.asFlow(publisher);
        }
    }
}

