/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.springframework.aop.support.AopUtils;
import org.springframework.expression.Expression;
import org.springframework.lang.NonNull;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.ExpressionAttribute;

final class PostFilterExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<ExpressionAttribute> {
    PostFilterExpressionAttributeRegistry() {
    }

    @Override
    @NonNull
    ExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        PostFilter postFilter = this.findPostFilterAnnotation(specificMethod);
        if (postFilter == null) {
            return ExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression postFilterExpression = this.getExpressionHandler().getExpressionParser().parseExpression(postFilter.value());
        return new ExpressionAttribute(postFilterExpression);
    }

    private PostFilter findPostFilterAnnotation(Method method) {
        Function<AnnotatedElement, PostFilter> lookup = this.findUniqueAnnotation(PostFilter.class);
        PostFilter postFilter = lookup.apply(method);
        return postFilter != null ? postFilter : lookup.apply(method.getDeclaringClass());
    }
}

