/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttributeRegistry;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.security.authorization.method.ReactiveExpressionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class PreAuthorizeReactiveAuthorizationManager
implements ReactiveAuthorizationManager<MethodInvocation>,
MethodAuthorizationDeniedHandler {
    private final PreAuthorizeExpressionAttributeRegistry registry = new PreAuthorizeExpressionAttributeRegistry();

    public PreAuthorizeReactiveAuthorizationManager() {
        this(new DefaultMethodSecurityExpressionHandler());
    }

    public PreAuthorizeReactiveAuthorizationManager(MethodSecurityExpressionHandler expressionHandler) {
        Assert.notNull((Object)expressionHandler, "expressionHandler cannot be null");
        this.registry.setExpressionHandler(expressionHandler);
    }

    public void setTemplateDefaults(PrePostTemplateDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.registry.setApplicationContext(context);
    }

    @Override
    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, MethodInvocation mi) {
        Object attribute = this.registry.getAttribute(mi);
        if (attribute == ExpressionAttribute.NULL_ATTRIBUTE) {
            return Mono.empty();
        }
        return authentication.map(auth -> this.registry.getExpressionHandler().createEvaluationContext((Authentication)auth, mi)).flatMap(ctx -> ReactiveExpressionUtils.evaluate(attribute.getExpression(), ctx)).cast(AuthorizationDecision.class);
    }

    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        Object attribute = this.registry.getAttribute(methodInvocation);
        PreAuthorizeExpressionAttribute preAuthorizeAttribute = (PreAuthorizeExpressionAttribute)attribute;
        return preAuthorizeAttribute.getHandler().handleDeniedInvocation(methodInvocation, authorizationResult);
    }
}

