/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.OAuth2AuthorizationSuccessHandler;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class AuthorizedClientServiceOAuth2AuthorizedClientManager
implements OAuth2AuthorizedClientManager {
    private static final OAuth2AuthorizedClientProvider DEFAULT_AUTHORIZED_CLIENT_PROVIDER = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizedClientService authorizedClientService;
    private OAuth2AuthorizedClientProvider authorizedClientProvider;
    private Function<OAuth2AuthorizeRequest, Map<String, Object>> contextAttributesMapper;
    private OAuth2AuthorizationSuccessHandler authorizationSuccessHandler;
    private OAuth2AuthorizationFailureHandler authorizationFailureHandler;

    public AuthorizedClientServiceOAuth2AuthorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientService, "authorizedClientService cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientService = authorizedClientService;
        this.authorizedClientProvider = DEFAULT_AUTHORIZED_CLIENT_PROVIDER;
        this.contextAttributesMapper = new DefaultContextAttributesMapper();
        this.authorizationSuccessHandler = (authorizedClient, principal2, attributes) -> authorizedClientService.saveAuthorizedClient(authorizedClient, principal2);
        this.authorizationFailureHandler = new RemoveAuthorizedClientOAuth2AuthorizationFailureHandler((clientRegistrationId, principal2, attributes) -> authorizedClientService.removeAuthorizedClient(clientRegistrationId, principal2.getName()));
    }

    @Override
    @Nullable
    public OAuth2AuthorizedClient authorize(OAuth2AuthorizeRequest authorizeRequest) {
        OAuth2AuthorizationContext.Builder contextBuilder;
        Assert.notNull((Object)authorizeRequest, "authorizeRequest cannot be null");
        String clientRegistrationId = authorizeRequest.getClientRegistrationId();
        OAuth2AuthorizedClient authorizedClient = authorizeRequest.getAuthorizedClient();
        Authentication principal2 = authorizeRequest.getPrincipal();
        if (authorizedClient != null) {
            contextBuilder = OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient);
        } else {
            ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
            Assert.notNull((Object)clientRegistration, "Could not find ClientRegistration with id '" + clientRegistrationId + "'");
            authorizedClient = this.authorizedClientService.loadAuthorizedClient(clientRegistrationId, principal2.getName());
            contextBuilder = authorizedClient != null ? OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient) : OAuth2AuthorizationContext.withClientRegistration(clientRegistration);
        }
        OAuth2AuthorizationContext authorizationContext = this.buildAuthorizationContext(authorizeRequest, principal2, contextBuilder);
        try {
            authorizedClient = this.authorizedClientProvider.authorize(authorizationContext);
        }
        catch (OAuth2AuthorizationException ex) {
            this.authorizationFailureHandler.onAuthorizationFailure(ex, principal2, Collections.emptyMap());
            throw ex;
        }
        if (authorizedClient != null) {
            this.authorizationSuccessHandler.onAuthorizationSuccess(authorizedClient, principal2, Collections.emptyMap());
        } else if (authorizationContext.getAuthorizedClient() != null) {
            return authorizationContext.getAuthorizedClient();
        }
        return authorizedClient;
    }

    private OAuth2AuthorizationContext buildAuthorizationContext(OAuth2AuthorizeRequest authorizeRequest, Authentication principal2, OAuth2AuthorizationContext.Builder contextBuilder) {
        return contextBuilder.principal(principal2).attributes(attributes -> {
            Map<String, Object> contextAttributes = this.contextAttributesMapper.apply(authorizeRequest);
            if (!CollectionUtils.isEmpty(contextAttributes)) {
                attributes.putAll(contextAttributes);
            }
        }).build();
    }

    public void setAuthorizedClientProvider(OAuth2AuthorizedClientProvider authorizedClientProvider) {
        Assert.notNull((Object)authorizedClientProvider, "authorizedClientProvider cannot be null");
        this.authorizedClientProvider = authorizedClientProvider;
    }

    public void setContextAttributesMapper(Function<OAuth2AuthorizeRequest, Map<String, Object>> contextAttributesMapper) {
        Assert.notNull(contextAttributesMapper, "contextAttributesMapper cannot be null");
        this.contextAttributesMapper = contextAttributesMapper;
    }

    public void setAuthorizationSuccessHandler(OAuth2AuthorizationSuccessHandler authorizationSuccessHandler) {
        Assert.notNull((Object)authorizationSuccessHandler, "authorizationSuccessHandler cannot be null");
        this.authorizationSuccessHandler = authorizationSuccessHandler;
    }

    public void setAuthorizationFailureHandler(OAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, "authorizationFailureHandler cannot be null");
        this.authorizationFailureHandler = authorizationFailureHandler;
    }

    public static class DefaultContextAttributesMapper
    implements Function<OAuth2AuthorizeRequest, Map<String, Object>> {
        @Override
        public Map<String, Object> apply(OAuth2AuthorizeRequest authorizeRequest) {
            Map<String, Object> contextAttributes = Collections.emptyMap();
            String scope = (String)authorizeRequest.getAttribute("scope");
            if (StringUtils.hasText(scope)) {
                contextAttributes = new HashMap<String, Object>();
                contextAttributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, StringUtils.delimitedListToStringArray(scope, " "));
            }
            return contextAttributes;
        }
    }
}

