/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationSuccessHandler;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager
implements ReactiveOAuth2AuthorizedClientManager {
    private static final ReactiveOAuth2AuthorizedClientProvider DEFAULT_AUTHORIZED_CLIENT_PROVIDER = ReactiveOAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final ReactiveOAuth2AuthorizedClientService authorizedClientService;
    private ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = DEFAULT_AUTHORIZED_CLIENT_PROVIDER;
    private Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper = new DefaultContextAttributesMapper();
    private ReactiveOAuth2AuthorizationSuccessHandler authorizationSuccessHandler;
    private ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler;

    public AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ReactiveOAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientService, "authorizedClientService cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientService = authorizedClientService;
        this.authorizationSuccessHandler = (authorizedClient, principal2, attributes) -> authorizedClientService.saveAuthorizedClient(authorizedClient, principal2);
        this.authorizationFailureHandler = new RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler((clientRegistrationId, principal2, attributes) -> this.authorizedClientService.removeAuthorizedClient(clientRegistrationId, principal2.getName()));
    }

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizeRequest authorizeRequest) {
        Assert.notNull((Object)authorizeRequest, "authorizeRequest cannot be null");
        return this.createAuthorizationContext(authorizeRequest).flatMap(authorizationContext -> this.authorize((OAuth2AuthorizationContext)authorizationContext, authorizeRequest.getPrincipal()));
    }

    private Mono<OAuth2AuthorizationContext> createAuthorizationContext(OAuth2AuthorizeRequest authorizeRequest) {
        String clientRegistrationId = authorizeRequest.getClientRegistrationId();
        Authentication principal2 = authorizeRequest.getPrincipal();
        return Mono.justOrEmpty((Object)authorizeRequest.getAuthorizedClient()).map(OAuth2AuthorizationContext::withAuthorizedClient).switchIfEmpty(Mono.defer(() -> this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).flatMap(clientRegistration -> this.authorizedClientService.loadAuthorizedClient(clientRegistrationId, principal2.getName()).map(OAuth2AuthorizationContext::withAuthorizedClient).switchIfEmpty(Mono.fromSupplier(() -> OAuth2AuthorizationContext.withClientRegistration(clientRegistration)))).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("Could not find ClientRegistration with id '" + clientRegistrationId + "'"))))).flatMap(contextBuilder -> this.contextAttributesMapper.apply(authorizeRequest).defaultIfEmpty(Collections.emptyMap()).map(contextAttributes -> {
            OAuth2AuthorizationContext.Builder builder = contextBuilder.principal(principal2);
            if (!contextAttributes.isEmpty()) {
                builder = builder.attributes(attributes -> attributes.putAll(contextAttributes));
            }
            return builder.build();
        }));
    }

    private Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext authorizationContext, Authentication principal2) {
        return this.authorizedClientProvider.authorize(authorizationContext).flatMap(authorizedClient -> this.authorizationSuccessHandler.onAuthorizationSuccess((OAuth2AuthorizedClient)authorizedClient, principal2, Collections.emptyMap()).thenReturn(authorizedClient)).onErrorResume(OAuth2AuthorizationException.class, authorizationException -> this.authorizationFailureHandler.onAuthorizationFailure((OAuth2AuthorizationException)authorizationException, principal2, Collections.emptyMap()).then(Mono.error((Throwable)authorizationException))).switchIfEmpty(Mono.defer(() -> Mono.justOrEmpty((Object)authorizationContext.getAuthorizedClient())));
    }

    public void setAuthorizedClientProvider(ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider) {
        Assert.notNull((Object)authorizedClientProvider, "authorizedClientProvider cannot be null");
        this.authorizedClientProvider = authorizedClientProvider;
    }

    public void setContextAttributesMapper(Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper) {
        Assert.notNull(contextAttributesMapper, "contextAttributesMapper cannot be null");
        this.contextAttributesMapper = contextAttributesMapper;
    }

    public void setAuthorizationSuccessHandler(ReactiveOAuth2AuthorizationSuccessHandler authorizationSuccessHandler) {
        Assert.notNull((Object)authorizationSuccessHandler, "authorizationSuccessHandler cannot be null");
        this.authorizationSuccessHandler = authorizationSuccessHandler;
    }

    public void setAuthorizationFailureHandler(ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, "authorizationFailureHandler cannot be null");
        this.authorizationFailureHandler = authorizationFailureHandler;
    }

    public static class DefaultContextAttributesMapper
    implements Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> {
        private final AuthorizedClientServiceOAuth2AuthorizedClientManager.DefaultContextAttributesMapper mapper = new AuthorizedClientServiceOAuth2AuthorizedClientManager.DefaultContextAttributesMapper();

        @Override
        public Mono<Map<String, Object>> apply(OAuth2AuthorizeRequest authorizeRequest) {
            return Mono.fromCallable(() -> this.mapper.apply(authorizeRequest));
        }
    }
}

