/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DelegatingReactiveOAuth2AuthorizedClientProvider
implements ReactiveOAuth2AuthorizedClientProvider {
    private final List<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders;

    public DelegatingReactiveOAuth2AuthorizedClientProvider(ReactiveOAuth2AuthorizedClientProvider ... authorizedClientProviders) {
        Assert.notEmpty((Object[])authorizedClientProviders, "authorizedClientProviders cannot be empty");
        this.authorizedClientProviders = Collections.unmodifiableList(Arrays.asList(authorizedClientProviders));
    }

    public DelegatingReactiveOAuth2AuthorizedClientProvider(List<ReactiveOAuth2AuthorizedClientProvider> authorizedClientProviders) {
        Assert.notEmpty(authorizedClientProviders, "authorizedClientProviders cannot be empty");
        this.authorizedClientProviders = Collections.unmodifiableList(new ArrayList<ReactiveOAuth2AuthorizedClientProvider>(authorizedClientProviders));
    }

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, "context cannot be null");
        return Flux.fromIterable(this.authorizedClientProviders).concatMap(authorizedClientProvider -> authorizedClientProvider.authorize(context)).next();
    }
}

