/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientId;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.Assert;

public final class InMemoryOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    private final Map<OAuth2AuthorizedClientId, OAuth2AuthorizedClient> authorizedClients;
    private final ClientRegistrationRepository clientRegistrationRepository;

    public InMemoryOAuth2AuthorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClients = new ConcurrentHashMap<OAuth2AuthorizedClientId, OAuth2AuthorizedClient>();
    }

    public InMemoryOAuth2AuthorizedClientService(ClientRegistrationRepository clientRegistrationRepository, Map<OAuth2AuthorizedClientId, OAuth2AuthorizedClient> authorizedClients) {
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        Assert.notEmpty(authorizedClients, "authorizedClients cannot be empty");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClients = new ConcurrentHashMap<OAuth2AuthorizedClientId, OAuth2AuthorizedClient>(authorizedClients);
    }

    @Override
    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.hasText(principalName, "principalName cannot be empty");
        ClientRegistration registration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (registration == null) {
            return null;
        }
        return (T)this.authorizedClients.get(new OAuth2AuthorizedClientId(clientRegistrationId, principalName));
    }

    @Override
    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
        Assert.notNull((Object)authorizedClient, "authorizedClient cannot be null");
        Assert.notNull((Object)principal2, "principal cannot be null");
        this.authorizedClients.put(new OAuth2AuthorizedClientId(authorizedClient.getClientRegistration().getRegistrationId(), principal2.getName()), authorizedClient);
    }

    @Override
    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.hasText(principalName, "principalName cannot be empty");
        ClientRegistration registration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (registration != null) {
            this.authorizedClients.remove(new OAuth2AuthorizedClientId(clientRegistrationId, principalName));
        }
    }
}

