/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JdbcOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    private static final String COLUMN_NAMES = "client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at";
    private static final String TABLE_NAME = "oauth2_authorized_client";
    private static final String PK_FILTER = "client_registration_id = ? AND principal_name = ?";
    private static final String LOAD_AUTHORIZED_CLIENT_SQL = "SELECT client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at FROM oauth2_authorized_client WHERE client_registration_id = ? AND principal_name = ?";
    private static final String SAVE_AUTHORIZED_CLIENT_SQL = "INSERT INTO oauth2_authorized_client (client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String REMOVE_AUTHORIZED_CLIENT_SQL = "DELETE FROM oauth2_authorized_client WHERE client_registration_id = ? AND principal_name = ?";
    private static final String UPDATE_AUTHORIZED_CLIENT_SQL = "UPDATE oauth2_authorized_client SET access_token_type = ?, access_token_value = ?, access_token_issued_at = ?, access_token_expires_at = ?, access_token_scopes = ?, refresh_token_value = ?, refresh_token_issued_at = ? WHERE client_registration_id = ? AND principal_name = ?";
    protected final JdbcOperations jdbcOperations;
    protected RowMapper<OAuth2AuthorizedClient> authorizedClientRowMapper;
    protected Function<OAuth2AuthorizedClientHolder, List<SqlParameterValue>> authorizedClientParametersMapper;
    protected final LobHandler lobHandler;

    public JdbcOAuth2AuthorizedClientService(JdbcOperations jdbcOperations, ClientRegistrationRepository clientRegistrationRepository) {
        this(jdbcOperations, clientRegistrationRepository, (LobHandler)new DefaultLobHandler());
    }

    public JdbcOAuth2AuthorizedClientService(JdbcOperations jdbcOperations, ClientRegistrationRepository clientRegistrationRepository, LobHandler lobHandler) {
        Assert.notNull((Object)jdbcOperations, "jdbcOperations cannot be null");
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        Assert.notNull((Object)lobHandler, "lobHandler cannot be null");
        this.jdbcOperations = jdbcOperations;
        this.lobHandler = lobHandler;
        OAuth2AuthorizedClientRowMapper authorizedClientRowMapper = new OAuth2AuthorizedClientRowMapper(clientRegistrationRepository);
        authorizedClientRowMapper.setLobHandler(lobHandler);
        this.authorizedClientRowMapper = authorizedClientRowMapper;
        this.authorizedClientParametersMapper = new OAuth2AuthorizedClientParametersMapper();
    }

    @Override
    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.hasText(principalName, "principalName cannot be empty");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)clientRegistrationId), new SqlParameterValue(12, (Object)principalName)};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        List result = this.jdbcOperations.query(LOAD_AUTHORIZED_CLIENT_SQL, (PreparedStatementSetter)pss, this.authorizedClientRowMapper);
        return (T)(!result.isEmpty() ? (OAuth2AuthorizedClient)result.get(0) : null);
    }

    @Override
    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
        boolean existsAuthorizedClient;
        Assert.notNull((Object)authorizedClient, "authorizedClient cannot be null");
        Assert.notNull((Object)principal2, "principal cannot be null");
        boolean bl = existsAuthorizedClient = null != this.loadAuthorizedClient(authorizedClient.getClientRegistration().getRegistrationId(), principal2.getName());
        if (existsAuthorizedClient) {
            this.updateAuthorizedClient(authorizedClient, principal2);
        } else {
            try {
                this.insertAuthorizedClient(authorizedClient, principal2);
            }
            catch (DuplicateKeyException ex) {
                this.updateAuthorizedClient(authorizedClient, principal2);
            }
        }
    }

    private void updateAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
        List<SqlParameterValue> parameters = this.authorizedClientParametersMapper.apply(new OAuth2AuthorizedClientHolder(authorizedClient, principal2));
        SqlParameterValue clientRegistrationIdParameter = parameters.remove(0);
        SqlParameterValue principalNameParameter = parameters.remove(0);
        parameters.add(clientRegistrationIdParameter);
        parameters.add(principalNameParameter);
        try (LobCreator lobCreator = this.lobHandler.getLobCreator();){
            LobCreatorArgumentPreparedStatementSetter pss = new LobCreatorArgumentPreparedStatementSetter(lobCreator, parameters.toArray());
            this.jdbcOperations.update(UPDATE_AUTHORIZED_CLIENT_SQL, (PreparedStatementSetter)pss);
        }
    }

    private void insertAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
        List<SqlParameterValue> parameters = this.authorizedClientParametersMapper.apply(new OAuth2AuthorizedClientHolder(authorizedClient, principal2));
        try (LobCreator lobCreator = this.lobHandler.getLobCreator();){
            LobCreatorArgumentPreparedStatementSetter pss = new LobCreatorArgumentPreparedStatementSetter(lobCreator, parameters.toArray());
            this.jdbcOperations.update(SAVE_AUTHORIZED_CLIENT_SQL, (PreparedStatementSetter)pss);
        }
    }

    @Override
    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.hasText(principalName, "principalName cannot be empty");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)clientRegistrationId), new SqlParameterValue(12, (Object)principalName)};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        this.jdbcOperations.update(REMOVE_AUTHORIZED_CLIENT_SQL, (PreparedStatementSetter)pss);
    }

    public final void setAuthorizedClientRowMapper(RowMapper<OAuth2AuthorizedClient> authorizedClientRowMapper) {
        Assert.notNull(authorizedClientRowMapper, "authorizedClientRowMapper cannot be null");
        this.authorizedClientRowMapper = authorizedClientRowMapper;
    }

    public final void setAuthorizedClientParametersMapper(Function<OAuth2AuthorizedClientHolder, List<SqlParameterValue>> authorizedClientParametersMapper) {
        Assert.notNull(authorizedClientParametersMapper, "authorizedClientParametersMapper cannot be null");
        this.authorizedClientParametersMapper = authorizedClientParametersMapper;
    }

    public static class OAuth2AuthorizedClientRowMapper
    implements RowMapper<OAuth2AuthorizedClient> {
        protected final ClientRegistrationRepository clientRegistrationRepository;
        protected LobHandler lobHandler = new DefaultLobHandler();

        public OAuth2AuthorizedClientRowMapper(ClientRegistrationRepository clientRegistrationRepository) {
            Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
            this.clientRegistrationRepository = clientRegistrationRepository;
        }

        public final void setLobHandler(LobHandler lobHandler) {
            Assert.notNull((Object)lobHandler, "lobHandler cannot be null");
            this.lobHandler = lobHandler;
        }

        public OAuth2AuthorizedClient mapRow(ResultSet rs, int rowNum) throws SQLException {
            String clientRegistrationId = rs.getString("client_registration_id");
            ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
            if (clientRegistration == null) {
                throw new DataRetrievalFailureException("The ClientRegistration with id '" + clientRegistrationId + "' exists in the data source, however, it was not found in the ClientRegistrationRepository.");
            }
            OAuth2AccessToken.TokenType tokenType = null;
            if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(rs.getString("access_token_type"))) {
                tokenType = OAuth2AccessToken.TokenType.BEARER;
            }
            String tokenValue = new String(this.lobHandler.getBlobAsBytes(rs, "access_token_value"), StandardCharsets.UTF_8);
            Instant issuedAt = rs.getTimestamp("access_token_issued_at").toInstant();
            Instant expiresAt = rs.getTimestamp("access_token_expires_at").toInstant();
            Set<String> scopes = Collections.emptySet();
            String accessTokenScopes = rs.getString("access_token_scopes");
            if (accessTokenScopes != null) {
                scopes = StringUtils.commaDelimitedListToSet(accessTokenScopes);
            }
            OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType, tokenValue, issuedAt, expiresAt, scopes);
            OAuth2RefreshToken refreshToken = null;
            byte[] refreshTokenValue = this.lobHandler.getBlobAsBytes(rs, "refresh_token_value");
            if (refreshTokenValue != null) {
                tokenValue = new String(refreshTokenValue, StandardCharsets.UTF_8);
                issuedAt = null;
                Timestamp refreshTokenIssuedAt = rs.getTimestamp("refresh_token_issued_at");
                if (refreshTokenIssuedAt != null) {
                    issuedAt = refreshTokenIssuedAt.toInstant();
                }
                refreshToken = new OAuth2RefreshToken(tokenValue, issuedAt);
            }
            String principalName = rs.getString("principal_name");
            return new OAuth2AuthorizedClient(clientRegistration, principalName, accessToken, refreshToken);
        }
    }

    public static class OAuth2AuthorizedClientParametersMapper
    implements Function<OAuth2AuthorizedClientHolder, List<SqlParameterValue>> {
        @Override
        public List<SqlParameterValue> apply(OAuth2AuthorizedClientHolder authorizedClientHolder) {
            OAuth2AuthorizedClient authorizedClient = authorizedClientHolder.getAuthorizedClient();
            Authentication principal2 = authorizedClientHolder.getPrincipal();
            ClientRegistration clientRegistration = authorizedClient.getClientRegistration();
            OAuth2AccessToken accessToken = authorizedClient.getAccessToken();
            OAuth2RefreshToken refreshToken = authorizedClient.getRefreshToken();
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            parameters.add(new SqlParameterValue(12, (Object)clientRegistration.getRegistrationId()));
            parameters.add(new SqlParameterValue(12, (Object)principal2.getName()));
            parameters.add(new SqlParameterValue(12, (Object)accessToken.getTokenType().getValue()));
            parameters.add(new SqlParameterValue(2004, (Object)accessToken.getTokenValue().getBytes(StandardCharsets.UTF_8)));
            parameters.add(new SqlParameterValue(93, (Object)Timestamp.from(accessToken.getIssuedAt())));
            parameters.add(new SqlParameterValue(93, (Object)Timestamp.from(accessToken.getExpiresAt())));
            String accessTokenScopes = null;
            if (!CollectionUtils.isEmpty(accessToken.getScopes())) {
                accessTokenScopes = StringUtils.collectionToDelimitedString(accessToken.getScopes(), ",");
            }
            parameters.add(new SqlParameterValue(12, (Object)accessTokenScopes));
            byte[] refreshTokenValue = null;
            Timestamp refreshTokenIssuedAt = null;
            if (refreshToken != null) {
                refreshTokenValue = refreshToken.getTokenValue().getBytes(StandardCharsets.UTF_8);
                if (refreshToken.getIssuedAt() != null) {
                    refreshTokenIssuedAt = Timestamp.from(refreshToken.getIssuedAt());
                }
            }
            parameters.add(new SqlParameterValue(2004, (Object)refreshTokenValue));
            parameters.add(new SqlParameterValue(93, (Object)refreshTokenIssuedAt));
            return parameters;
        }
    }

    public static final class OAuth2AuthorizedClientHolder {
        private final OAuth2AuthorizedClient authorizedClient;
        private final Authentication principal;

        public OAuth2AuthorizedClientHolder(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
            Assert.notNull((Object)authorizedClient, "authorizedClient cannot be null");
            Assert.notNull((Object)principal2, "principal cannot be null");
            this.authorizedClient = authorizedClient;
            this.principal = principal2;
        }

        public OAuth2AuthorizedClient getAuthorizedClient() {
            return this.authorizedClient;
        }

        public Authentication getPrincipal() {
            return this.principal;
        }
    }

    private static final class LobCreatorArgumentPreparedStatementSetter
    extends ArgumentPreparedStatementSetter {
        protected final LobCreator lobCreator;

        private LobCreatorArgumentPreparedStatementSetter(LobCreator lobCreator, Object[] args) {
            super(args);
            this.lobCreator = lobCreator;
        }

        protected void doSetValue(PreparedStatement ps, int parameterPosition, Object argValue) throws SQLException {
            SqlParameterValue paramValue;
            if (argValue instanceof SqlParameterValue && (paramValue = (SqlParameterValue)argValue).getSqlType() == 2004) {
                if (paramValue.getValue() != null) {
                    Assert.isInstanceOf(byte[].class, paramValue.getValue(), "Value of blob parameter must be byte[]");
                }
                byte[] valueBytes = (byte[])paramValue.getValue();
                this.lobCreator.setBlobAsBytes(ps, parameterPosition, valueBytes);
                return;
            }
            super.doSetValue(ps, parameterPosition, argValue);
        }
    }
}

