/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.Assert;

public final class OAuth2AuthorizedClientId
implements Serializable {
    private static final long serialVersionUID = 620L;
    private final String clientRegistrationId;
    private final String principalName;

    public OAuth2AuthorizedClientId(String clientRegistrationId, String principalName) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.hasText(principalName, "principalName cannot be empty");
        this.clientRegistrationId = clientRegistrationId;
        this.principalName = principalName;
    }

    public String getClientRegistrationId() {
        return this.clientRegistrationId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2AuthorizedClientId that = (OAuth2AuthorizedClientId)obj;
        return Objects.equals(this.clientRegistrationId, that.clientRegistrationId) && Objects.equals(this.principalName, that.principalName);
    }

    public int hashCode() {
        return Objects.hash(this.clientRegistrationId, this.principalName);
    }
}

