/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class R2dbcReactiveOAuth2AuthorizedClientService
implements ReactiveOAuth2AuthorizedClientService {
    private static final String COLUMN_NAMES = "client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at";
    private static final String TABLE_NAME = "oauth2_authorized_client";
    private static final String PK_FILTER = "client_registration_id = :clientRegistrationId AND principal_name = :principalName";
    private static final String LOAD_AUTHORIZED_CLIENT_SQL = "SELECT client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at FROM oauth2_authorized_client WHERE client_registration_id = :clientRegistrationId AND principal_name = :principalName";
    private static final String SAVE_AUTHORIZED_CLIENT_SQL = "INSERT INTO oauth2_authorized_client (client_registration_id, principal_name, access_token_type, access_token_value, access_token_issued_at, access_token_expires_at, access_token_scopes, refresh_token_value, refresh_token_issued_at)VALUES (:clientRegistrationId, :principalName, :accessTokenType, :accessTokenValue, :accessTokenIssuedAt, :accessTokenExpiresAt, :accessTokenScopes, :refreshTokenValue, :refreshTokenIssuedAt)";
    private static final String REMOVE_AUTHORIZED_CLIENT_SQL = "DELETE FROM oauth2_authorized_client WHERE client_registration_id = :clientRegistrationId AND principal_name = :principalName";
    private static final String UPDATE_AUTHORIZED_CLIENT_SQL = "UPDATE oauth2_authorized_client SET access_token_type = :accessTokenType,  access_token_value = :accessTokenValue,  access_token_issued_at = :accessTokenIssuedAt, access_token_expires_at = :accessTokenExpiresAt,  access_token_scopes = :accessTokenScopes, refresh_token_value = :refreshTokenValue,  refresh_token_issued_at = :refreshTokenIssuedAt WHERE client_registration_id = :clientRegistrationId AND principal_name = :principalName";
    protected final DatabaseClient databaseClient;
    protected final ReactiveClientRegistrationRepository clientRegistrationRepository;
    protected Function<OAuth2AuthorizedClientHolder, Map<String, Parameter>> authorizedClientParametersMapper;
    protected BiFunction<Row, RowMetadata, OAuth2AuthorizedClientHolder> authorizedClientRowMapper;

    public R2dbcReactiveOAuth2AuthorizedClientService(DatabaseClient databaseClient, ReactiveClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)databaseClient, "databaseClient cannot be null");
        Assert.notNull((Object)clientRegistrationRepository, "clientRegistrationRepository cannot be null");
        this.databaseClient = databaseClient;
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientParametersMapper = new OAuth2AuthorizedClientParametersMapper();
        this.authorizedClientRowMapper = new OAuth2AuthorizedClientRowMapper();
    }

    @Override
    public <T extends OAuth2AuthorizedClient> Mono<T> loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.hasText(principalName, "principalName cannot be empty");
        return this.databaseClient.sql(LOAD_AUTHORIZED_CLIENT_SQL).bind("clientRegistrationId", (Object)clientRegistrationId).bind("principalName", (Object)principalName).map(this.authorizedClientRowMapper).first().flatMap(this::getAuthorizedClient);
    }

    private Mono<OAuth2AuthorizedClient> getAuthorizedClient(OAuth2AuthorizedClientHolder authorizedClientHolder) {
        return this.clientRegistrationRepository.findByRegistrationId(authorizedClientHolder.getClientRegistrationId()).switchIfEmpty(Mono.error((Throwable)R2dbcReactiveOAuth2AuthorizedClientService.dataRetrievalFailureException(authorizedClientHolder.getClientRegistrationId()))).map(clientRegistration -> new OAuth2AuthorizedClient((ClientRegistration)clientRegistration, authorizedClientHolder.getPrincipalName(), authorizedClientHolder.getAccessToken(), authorizedClientHolder.getRefreshToken()));
    }

    private static Throwable dataRetrievalFailureException(String clientRegistrationId) {
        return new DataRetrievalFailureException("The ClientRegistration with id '" + clientRegistrationId + "' exists in the data source, however, it was not found in the ReactiveClientRegistrationRepository.");
    }

    @Override
    public Mono<Void> saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
        Assert.notNull((Object)authorizedClient, "authorizedClient cannot be null");
        Assert.notNull((Object)principal2, "principal cannot be null");
        return this.loadAuthorizedClient(authorizedClient.getClientRegistration().getRegistrationId(), principal2.getName()).flatMap(dbAuthorizedClient -> this.updateAuthorizedClient(authorizedClient, principal2)).switchIfEmpty(Mono.defer(() -> this.insertAuthorizedClient(authorizedClient, principal2))).then();
    }

    private Mono<Long> updateAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
        DatabaseClient.GenericExecuteSpec executeSpec = this.databaseClient.sql(UPDATE_AUTHORIZED_CLIENT_SQL);
        for (Map.Entry<String, Parameter> entry : this.authorizedClientParametersMapper.apply(new OAuth2AuthorizedClientHolder(authorizedClient, principal2)).entrySet()) {
            executeSpec = executeSpec.bind(entry.getKey(), (Object)entry.getValue());
        }
        return executeSpec.fetch().rowsUpdated();
    }

    private Mono<Long> insertAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
        DatabaseClient.GenericExecuteSpec executeSpec = this.databaseClient.sql(SAVE_AUTHORIZED_CLIENT_SQL);
        for (Map.Entry<String, Parameter> entry : this.authorizedClientParametersMapper.apply(new OAuth2AuthorizedClientHolder(authorizedClient, principal2)).entrySet()) {
            executeSpec = executeSpec.bind(entry.getKey(), (Object)entry.getValue());
        }
        return executeSpec.fetch().rowsUpdated();
    }

    @Override
    public Mono<Void> removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
        Assert.hasText(principalName, "principalName cannot be empty");
        return this.databaseClient.sql(REMOVE_AUTHORIZED_CLIENT_SQL).bind("clientRegistrationId", (Object)clientRegistrationId).bind("principalName", (Object)principalName).then();
    }

    public final void setAuthorizedClientParametersMapper(Function<OAuth2AuthorizedClientHolder, Map<String, Parameter>> authorizedClientParametersMapper) {
        Assert.notNull(authorizedClientParametersMapper, "authorizedClientParametersMapper cannot be null");
        this.authorizedClientParametersMapper = authorizedClientParametersMapper;
    }

    public final void setAuthorizedClientRowMapper(BiFunction<Row, RowMetadata, OAuth2AuthorizedClientHolder> authorizedClientRowMapper) {
        Assert.notNull(authorizedClientRowMapper, "authorizedClientRowMapper cannot be null");
        this.authorizedClientRowMapper = authorizedClientRowMapper;
    }

    public static class OAuth2AuthorizedClientParametersMapper
    implements Function<OAuth2AuthorizedClientHolder, Map<String, Parameter>> {
        @Override
        public Map<String, Parameter> apply(OAuth2AuthorizedClientHolder authorizedClientHolder) {
            HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
            OAuth2AccessToken accessToken = authorizedClientHolder.getAccessToken();
            OAuth2RefreshToken refreshToken = authorizedClientHolder.getRefreshToken();
            parameters.put("clientRegistrationId", Parameter.fromOrEmpty((Object)authorizedClientHolder.getClientRegistrationId(), String.class));
            parameters.put("principalName", Parameter.fromOrEmpty((Object)authorizedClientHolder.getPrincipalName(), String.class));
            parameters.put("accessTokenType", Parameter.fromOrEmpty((Object)accessToken.getTokenType().getValue(), String.class));
            parameters.put("accessTokenValue", Parameter.fromOrEmpty((Object)ByteBuffer.wrap(accessToken.getTokenValue().getBytes(StandardCharsets.UTF_8)), ByteBuffer.class));
            parameters.put("accessTokenIssuedAt", Parameter.fromOrEmpty((Object)LocalDateTime.ofInstant(accessToken.getIssuedAt(), ZoneOffset.UTC), LocalDateTime.class));
            parameters.put("accessTokenExpiresAt", Parameter.fromOrEmpty((Object)LocalDateTime.ofInstant(accessToken.getExpiresAt(), ZoneOffset.UTC), LocalDateTime.class));
            String accessTokenScopes = null;
            if (!CollectionUtils.isEmpty(accessToken.getScopes())) {
                accessTokenScopes = StringUtils.collectionToDelimitedString(accessToken.getScopes(), ",");
            }
            parameters.put("accessTokenScopes", Parameter.fromOrEmpty((Object)accessTokenScopes, String.class));
            ByteBuffer refreshTokenValue = null;
            LocalDateTime refreshTokenIssuedAt = null;
            if (refreshToken != null) {
                refreshTokenValue = ByteBuffer.wrap(refreshToken.getTokenValue().getBytes(StandardCharsets.UTF_8));
                if (refreshToken.getIssuedAt() != null) {
                    refreshTokenIssuedAt = LocalDateTime.ofInstant(refreshToken.getIssuedAt(), ZoneOffset.UTC);
                }
            }
            parameters.put("refreshTokenValue", Parameter.fromOrEmpty(refreshTokenValue, ByteBuffer.class));
            parameters.put("refreshTokenIssuedAt", Parameter.fromOrEmpty(refreshTokenIssuedAt, LocalDateTime.class));
            return parameters;
        }
    }

    public static class OAuth2AuthorizedClientRowMapper
    implements BiFunction<Row, RowMetadata, OAuth2AuthorizedClientHolder> {
        @Override
        public OAuth2AuthorizedClientHolder apply(Row row, RowMetadata rowMetadata) {
            String dbClientRegistrationId = (String)row.get("client_registration_id", String.class);
            OAuth2AccessToken.TokenType tokenType = null;
            if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase((String)row.get("access_token_type", String.class))) {
                tokenType = OAuth2AccessToken.TokenType.BEARER;
            }
            String tokenValue = new String(((ByteBuffer)row.get("access_token_value", ByteBuffer.class)).array(), StandardCharsets.UTF_8);
            Instant issuedAt = ((LocalDateTime)row.get("access_token_issued_at", LocalDateTime.class)).toInstant(ZoneOffset.UTC);
            Instant expiresAt = ((LocalDateTime)row.get("access_token_expires_at", LocalDateTime.class)).toInstant(ZoneOffset.UTC);
            Set<String> scopes = Collections.emptySet();
            String accessTokenScopes = (String)row.get("access_token_scopes", String.class);
            if (accessTokenScopes != null) {
                scopes = StringUtils.commaDelimitedListToSet(accessTokenScopes);
            }
            OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType, tokenValue, issuedAt, expiresAt, scopes);
            OAuth2RefreshToken refreshToken = null;
            ByteBuffer refreshTokenValue = (ByteBuffer)row.get("refresh_token_value", ByteBuffer.class);
            if (refreshTokenValue != null) {
                tokenValue = new String(refreshTokenValue.array(), StandardCharsets.UTF_8);
                issuedAt = null;
                LocalDateTime refreshTokenIssuedAt = (LocalDateTime)row.get("refresh_token_issued_at", LocalDateTime.class);
                if (refreshTokenIssuedAt != null) {
                    issuedAt = refreshTokenIssuedAt.toInstant(ZoneOffset.UTC);
                }
                refreshToken = new OAuth2RefreshToken(tokenValue, issuedAt);
            }
            String dbPrincipalName = (String)row.get("principal_name", String.class);
            return new OAuth2AuthorizedClientHolder(dbClientRegistrationId, dbPrincipalName, accessToken, refreshToken);
        }
    }

    public static final class OAuth2AuthorizedClientHolder {
        private final String clientRegistrationId;
        private final String principalName;
        private final OAuth2AccessToken accessToken;
        private final OAuth2RefreshToken refreshToken;

        public OAuth2AuthorizedClientHolder(OAuth2AuthorizedClient authorizedClient, Authentication principal2) {
            Assert.notNull((Object)authorizedClient, "authorizedClient cannot be null");
            Assert.notNull((Object)principal2, "principal cannot be null");
            this.clientRegistrationId = authorizedClient.getClientRegistration().getRegistrationId();
            this.principalName = principal2.getName();
            this.accessToken = authorizedClient.getAccessToken();
            this.refreshToken = authorizedClient.getRefreshToken();
        }

        public OAuth2AuthorizedClientHolder(String clientRegistrationId, String principalName, OAuth2AccessToken accessToken, OAuth2RefreshToken refreshToken) {
            Assert.hasText(clientRegistrationId, "clientRegistrationId cannot be empty");
            Assert.hasText(principalName, "principalName cannot be empty");
            Assert.notNull((Object)accessToken, "accessToken cannot be null");
            this.clientRegistrationId = clientRegistrationId;
            this.principalName = principalName;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
        }

        public String getClientRegistrationId() {
            return this.clientRegistrationId;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public OAuth2AccessToken getAccessToken() {
            return this.accessToken;
        }

        public OAuth2RefreshToken getRefreshToken() {
            return this.refreshToken;
        }
    }
}

