/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.net.URI;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.DefaultOAuth2TokenRequestHeadersConverter;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

abstract class AbstractOAuth2AuthorizationGrantRequestEntityConverter<T extends AbstractOAuth2AuthorizationGrantRequest>
implements Converter<T, RequestEntity<?>> {
    private Converter<T, HttpHeaders> headersConverter = DefaultOAuth2TokenRequestHeadersConverter.withCharsetUtf8();
    private Converter<T, MultiValueMap<String, String>> parametersConverter = this::createParameters;

    AbstractOAuth2AuthorizationGrantRequestEntityConverter() {
    }

    @Override
    public RequestEntity<?> convert(T authorizationGrantRequest) {
        HttpHeaders headers = this.getHeadersConverter().convert(authorizationGrantRequest);
        MultiValueMap<String, String> parameters = this.getParametersConverter().convert(authorizationGrantRequest);
        URI uri = UriComponentsBuilder.fromUriString(((AbstractOAuth2AuthorizationGrantRequest)authorizationGrantRequest).getClientRegistration().getProviderDetails().getTokenUri()).build().toUri();
        return new RequestEntity<MultiValueMap<String, String>>(parameters, headers, HttpMethod.POST, uri);
    }

    abstract MultiValueMap<String, String> createParameters(T var1);

    final Converter<T, HttpHeaders> getHeadersConverter() {
        return this.headersConverter;
    }

    public final void setHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, "headersConverter cannot be null");
        this.headersConverter = headersConverter;
    }

    public final void addHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, "headersConverter cannot be null");
        Converter currentHeadersConverter = this.headersConverter;
        this.headersConverter = authorizationGrantRequest -> {
            HttpHeaders headersToAdd;
            HttpHeaders headers = (HttpHeaders)currentHeadersConverter.convert(authorizationGrantRequest);
            if (headers == null) {
                headers = new HttpHeaders();
            }
            if ((headersToAdd = (HttpHeaders)headersConverter.convert(authorizationGrantRequest)) != null) {
                headers.addAll(headersToAdd);
            }
            return headers;
        };
    }

    final Converter<T, MultiValueMap<String, String>> getParametersConverter() {
        return this.parametersConverter;
    }

    public final void setParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, "parametersConverter cannot be null");
        this.parametersConverter = parametersConverter;
    }

    public final void addParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, "parametersConverter cannot be null");
        Converter currentParametersConverter = this.parametersConverter;
        this.parametersConverter = authorizationGrantRequest -> {
            MultiValueMap parametersToAdd;
            LinkedMultiValueMap parameters = (LinkedMultiValueMap)currentParametersConverter.convert(authorizationGrantRequest);
            if (parameters == null) {
                parameters = new LinkedMultiValueMap();
            }
            if ((parametersToAdd = (MultiValueMap)parametersConverter.convert(authorizationGrantRequest)) != null) {
                parameters.addAll(parametersToAdd);
            }
            return parameters;
        };
    }
}

