/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2RefreshTokenGrantRequestEntityConverter
extends AbstractOAuth2AuthorizationGrantRequestEntityConverter<OAuth2RefreshTokenGrantRequest> {
    @Override
    protected MultiValueMap<String, String> createParameters(OAuth2RefreshTokenGrantRequest refreshTokenGrantRequest) {
        ClientRegistration clientRegistration = refreshTokenGrantRequest.getClientRegistration();
        LinkedMultiValueMap<String, String> parameters = new LinkedMultiValueMap<String, String>();
        parameters.add("grant_type", refreshTokenGrantRequest.getGrantType().getValue());
        parameters.add("refresh_token", refreshTokenGrantRequest.getRefreshToken().getTokenValue());
        if (!CollectionUtils.isEmpty(refreshTokenGrantRequest.getScopes())) {
            parameters.add("scope", StringUtils.collectionToDelimitedString(refreshTokenGrantRequest.getScopes(), " "));
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals(clientRegistration.getClientAuthenticationMethod())) {
            parameters.add("client_id", clientRegistration.getClientId());
            parameters.add("client_secret", clientRegistration.getClientSecret());
        }
        return parameters;
    }
}

