/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class TokenExchangeGrantRequestEntityConverter
extends AbstractOAuth2AuthorizationGrantRequestEntityConverter<TokenExchangeGrantRequest> {
    private static final String ACCESS_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String JWT_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:jwt";

    @Override
    protected MultiValueMap<String, String> createParameters(TokenExchangeGrantRequest grantRequest) {
        ClientRegistration clientRegistration = grantRequest.getClientRegistration();
        LinkedMultiValueMap<String, String> parameters = new LinkedMultiValueMap<String, String>();
        parameters.add("grant_type", grantRequest.getGrantType().getValue());
        parameters.add("requested_token_type", ACCESS_TOKEN_TYPE_VALUE);
        OAuth2Token subjectToken = grantRequest.getSubjectToken();
        parameters.add("subject_token", subjectToken.getTokenValue());
        parameters.add("subject_token_type", TokenExchangeGrantRequestEntityConverter.tokenType(subjectToken));
        OAuth2Token actorToken = grantRequest.getActorToken();
        if (actorToken != null) {
            parameters.add("actor_token", actorToken.getTokenValue());
            parameters.add("actor_token_type", TokenExchangeGrantRequestEntityConverter.tokenType(actorToken));
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            parameters.add("scope", StringUtils.collectionToDelimitedString(clientRegistration.getScopes(), " "));
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals(clientRegistration.getClientAuthenticationMethod())) {
            parameters.add("client_id", clientRegistration.getClientId());
            parameters.add("client_secret", clientRegistration.getClientSecret());
        }
        return parameters;
    }

    private static String tokenType(OAuth2Token token) {
        return token instanceof Jwt ? JWT_TOKEN_TYPE_VALUE : ACCESS_TOKEN_TYPE_VALUE;
    }
}

