/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Set;
import org.springframework.security.oauth2.client.endpoint.AbstractWebClientReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.web.reactive.function.BodyInserters;

public final class WebClientReactiveTokenExchangeTokenResponseClient
extends AbstractWebClientReactiveOAuth2AccessTokenResponseClient<TokenExchangeGrantRequest> {
    private static final String ACCESS_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String JWT_TOKEN_TYPE_VALUE = "urn:ietf:params:oauth:token-type:jwt";

    @Override
    ClientRegistration clientRegistration(TokenExchangeGrantRequest grantRequest) {
        return grantRequest.getClientRegistration();
    }

    @Override
    Set<String> scopes(TokenExchangeGrantRequest grantRequest) {
        return grantRequest.getClientRegistration().getScopes();
    }

    @Override
    BodyInserters.FormInserter<String> populateTokenRequestBody(TokenExchangeGrantRequest grantRequest, BodyInserters.FormInserter<String> body2) {
        super.populateTokenRequestBody(grantRequest, body2);
        body2.with("requested_token_type", (Object)ACCESS_TOKEN_TYPE_VALUE);
        OAuth2Token subjectToken = grantRequest.getSubjectToken();
        body2.with("subject_token", (Object)subjectToken.getTokenValue());
        body2.with("subject_token_type", (Object)WebClientReactiveTokenExchangeTokenResponseClient.tokenType(subjectToken));
        OAuth2Token actorToken = grantRequest.getActorToken();
        if (actorToken != null) {
            body2.with("actor_token", (Object)actorToken.getTokenValue());
            body2.with("actor_token_type", (Object)WebClientReactiveTokenExchangeTokenResponseClient.tokenType(actorToken));
        }
        return body2;
    }

    private static String tokenType(OAuth2Token token) {
        return token instanceof Jwt ? JWT_TOKEN_TYPE_VALUE : ACCESS_TOKEN_TYPE_VALUE;
    }
}

