/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication.logout;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.client.oidc.authentication.logout.LogoutTokenClaimAccessor;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.util.Assert;

public class OidcLogoutToken
extends AbstractOAuth2Token
implements LogoutTokenClaimAccessor {
    private static final String BACKCHANNEL_LOGOUT_TOKEN_EVENT_NAME = "http://schemas.openid.net/event/backchannel-logout";
    private final Map<String, Object> claims;

    OidcLogoutToken(String tokenValue, Instant issuedAt, Map<String, Object> claims) {
        super(tokenValue, issuedAt, Instant.MAX);
        this.claims = Collections.unmodifiableMap(claims);
        Assert.notNull(claims, "claims must not be null");
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public static Builder withTokenValue(String tokenValue) {
        return new Builder(tokenValue);
    }

    public static final class Builder {
        private String tokenValue;
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        private Builder(String tokenValue) {
            this.tokenValue = tokenValue;
            this.claims.put("events", Collections.singletonMap(OidcLogoutToken.BACKCHANNEL_LOGOUT_TOKEN_EVENT_NAME, Collections.emptyMap()));
        }

        public Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public Builder claim(String name, Object value) {
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public Builder audience(Collection<String> audience) {
            return this.claim("aud", audience);
        }

        public Builder issuedAt(Instant issuedAt) {
            return this.claim("iat", issuedAt);
        }

        public Builder issuer(String issuer) {
            return this.claim("iss", issuer);
        }

        public Builder jti(String jti) {
            return this.claim("jti", jti);
        }

        public Builder subject(String subject) {
            return this.claim("sub", subject);
        }

        public Builder events(Map<String, Object> events) {
            return this.claim("events", events);
        }

        public Builder sessionId(String sessionId) {
            return this.claim("sid", sessionId);
        }

        public OidcLogoutToken build() {
            Assert.notNull(this.claims.get("iss"), "issuer must not be null");
            Assert.isInstanceOf(Collection.class, this.claims.get("aud"), "audience must be a collection");
            Assert.notEmpty((Collection)this.claims.get("aud"), "audience must not be empty");
            Assert.notNull(this.claims.get("jti"), "jti must not be null");
            Assert.isTrue(this.hasLogoutTokenIdentifyingMember(), "logout token must contain an events claim that contains a member called 'http://schemas.openid.net/event/backchannel-logout' whose value is an empty Map");
            Assert.isNull(this.claims.get("nonce"), "logout token must not contain a nonce claim");
            Instant iat = this.toInstant(this.claims.get("iat"));
            return new OidcLogoutToken(this.tokenValue, iat, this.claims);
        }

        private boolean hasLogoutTokenIdentifyingMember() {
            Object object = this.claims.get("events");
            if (!(object instanceof Map)) {
                return false;
            }
            Map events = (Map)object;
            Object v = events.get(OidcLogoutToken.BACKCHANNEL_LOGOUT_TOKEN_EVENT_NAME);
            if (!(v instanceof Map)) {
                return false;
            }
            Map object2 = (Map)v;
            return object2.isEmpty();
        }

        private Instant toInstant(Object timestamp) {
            if (timestamp != null) {
                Assert.isInstanceOf(Instant.class, timestamp, "timestamps must be of type Instant");
            }
            return (Instant)timestamp;
        }
    }
}

