/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.userinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;

public class DelegatingOAuth2UserService<R extends OAuth2UserRequest, U extends OAuth2User>
implements OAuth2UserService<R, U> {
    private final List<OAuth2UserService<R, U>> userServices;

    public DelegatingOAuth2UserService(List<OAuth2UserService<R, U>> userServices) {
        Assert.notEmpty(userServices, "userServices cannot be empty");
        this.userServices = Collections.unmodifiableList(new ArrayList<OAuth2UserService<R, U>>(userServices));
    }

    @Override
    public U loadUser(R userRequest) throws OAuth2AuthenticationException {
        Assert.notNull(userRequest, "userRequest cannot be null");
        return (U)((OAuth2User)this.userServices.stream().map(userService -> userService.loadUser(userRequest)).filter(Objects::nonNull).findFirst().orElse(null));
    }
}

