/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;

public final class AuthenticatedPrincipalOAuth2AuthorizedClientRepository
implements OAuth2AuthorizedClientRepository {
    private final AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private final OAuth2AuthorizedClientService authorizedClientService;
    private OAuth2AuthorizedClientRepository anonymousAuthorizedClientRepository = new HttpSessionOAuth2AuthorizedClientRepository();

    public AuthenticatedPrincipalOAuth2AuthorizedClientRepository(OAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)authorizedClientService, "authorizedClientService cannot be null");
        this.authorizedClientService = authorizedClientService;
    }

    public void setAnonymousAuthorizedClientRepository(OAuth2AuthorizedClientRepository anonymousAuthorizedClientRepository) {
        Assert.notNull((Object)anonymousAuthorizedClientRepository, "anonymousAuthorizedClientRepository cannot be null");
        this.anonymousAuthorizedClientRepository = anonymousAuthorizedClientRepository;
    }

    @Override
    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, Authentication principal2, HttpServletRequest request) {
        if (this.isPrincipalAuthenticated(principal2)) {
            return this.authorizedClientService.loadAuthorizedClient(clientRegistrationId, principal2.getName());
        }
        return this.anonymousAuthorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal2, request);
    }

    @Override
    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2, HttpServletRequest request, HttpServletResponse response) {
        if (this.isPrincipalAuthenticated(principal2)) {
            this.authorizedClientService.saveAuthorizedClient(authorizedClient, principal2);
        } else {
            this.anonymousAuthorizedClientRepository.saveAuthorizedClient(authorizedClient, principal2, request, response);
        }
    }

    @Override
    public void removeAuthorizedClient(String clientRegistrationId, Authentication principal2, HttpServletRequest request, HttpServletResponse response) {
        if (this.isPrincipalAuthenticated(principal2)) {
            this.authorizedClientService.removeAuthorizedClient(clientRegistrationId, principal2.getName());
        } else {
            this.anonymousAuthorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal2, request, response);
        }
    }

    private boolean isPrincipalAuthenticated(Authentication authentication) {
        return this.authenticationTrustResolver.isAuthenticated(authentication);
    }
}

