/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.server.WebSessionServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository
implements ServerOAuth2AuthorizedClientRepository {
    private final AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private final ReactiveOAuth2AuthorizedClientService authorizedClientService;
    private ServerOAuth2AuthorizedClientRepository anonymousAuthorizedClientRepository = new WebSessionServerOAuth2AuthorizedClientRepository();

    public AuthenticatedPrincipalServerOAuth2AuthorizedClientRepository(ReactiveOAuth2AuthorizedClientService authorizedClientService) {
        Assert.notNull((Object)authorizedClientService, "authorizedClientService cannot be null");
        this.authorizedClientService = authorizedClientService;
    }

    public void setAnonymousAuthorizedClientRepository(ServerOAuth2AuthorizedClientRepository anonymousAuthorizedClientRepository) {
        Assert.notNull((Object)anonymousAuthorizedClientRepository, "anonymousAuthorizedClientRepository cannot be null");
        this.anonymousAuthorizedClientRepository = anonymousAuthorizedClientRepository;
    }

    @Override
    public <T extends OAuth2AuthorizedClient> Mono<T> loadAuthorizedClient(String clientRegistrationId, Authentication principal2, ServerWebExchange exchange2) {
        if (this.isPrincipalAuthenticated(principal2)) {
            return this.authorizedClientService.loadAuthorizedClient(clientRegistrationId, principal2.getName());
        }
        return this.anonymousAuthorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal2, exchange2);
    }

    @Override
    public Mono<Void> saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal2, ServerWebExchange exchange2) {
        if (this.isPrincipalAuthenticated(principal2)) {
            return this.authorizedClientService.saveAuthorizedClient(authorizedClient, principal2);
        }
        return this.anonymousAuthorizedClientRepository.saveAuthorizedClient(authorizedClient, principal2, exchange2);
    }

    @Override
    public Mono<Void> removeAuthorizedClient(String clientRegistrationId, Authentication principal2, ServerWebExchange exchange2) {
        if (this.isPrincipalAuthenticated(principal2)) {
            return this.authorizedClientService.removeAuthorizedClient(clientRegistrationId, principal2.getName());
        }
        return this.anonymousAuthorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal2, exchange2);
    }

    private boolean isPrincipalAuthenticated(Authentication authentication) {
        return this.authenticationTrustResolver.isAuthenticated(authentication);
    }
}

