/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.Map;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

final class OAuth2AuthorizationResponseUtils {
    private OAuth2AuthorizationResponseUtils() {
    }

    static MultiValueMap<String, String> toMultiMap(Map<String, String[]> map) {
        LinkedMultiValueMap<String, String> params = new LinkedMultiValueMap<String, String>(map.size());
        map.forEach((key, values) -> {
            if (((String[])values).length > 0) {
                for (String value : values) {
                    params.add((String)key, value);
                }
            }
        });
        return params;
    }

    static boolean isAuthorizationResponse(MultiValueMap<String, String> request) {
        return OAuth2AuthorizationResponseUtils.isAuthorizationResponseSuccess(request) || OAuth2AuthorizationResponseUtils.isAuthorizationResponseError(request);
    }

    static boolean isAuthorizationResponseSuccess(MultiValueMap<String, String> request) {
        return StringUtils.hasText(request.getFirst("code")) && StringUtils.hasText(request.getFirst("state"));
    }

    static boolean isAuthorizationResponseError(MultiValueMap<String, String> request) {
        return StringUtils.hasText(request.getFirst("error")) && StringUtils.hasText(request.getFirst("state"));
    }

    static OAuth2AuthorizationResponse convert(MultiValueMap<String, String> request, String redirectUri) {
        String code = request.getFirst("code");
        String errorCode = request.getFirst("error");
        String state = request.getFirst("state");
        if (StringUtils.hasText(code)) {
            return OAuth2AuthorizationResponse.success(code).redirectUri(redirectUri).state(state).build();
        }
        String errorDescription = request.getFirst("error_description");
        String errorUri = request.getFirst("error_uri");
        return OAuth2AuthorizationResponse.error(errorCode).redirectUri(redirectUri).errorDescription(errorDescription).errorUri(errorUri).state(state).build();
    }
}

