/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.authorization;

import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.util.Assert;

public final class OAuth2ReactiveAuthorizationManagers {
    private OAuth2ReactiveAuthorizationManagers() {
    }

    public static <T> ReactiveAuthorizationManager<T> hasScope(String scope) {
        OAuth2ReactiveAuthorizationManagers.assertScope(scope);
        return AuthorityReactiveAuthorizationManager.hasAuthority("SCOPE_" + scope);
    }

    public static <T> ReactiveAuthorizationManager<T> hasAnyScope(String ... scopes) {
        String[] mappedScopes = new String[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            OAuth2ReactiveAuthorizationManagers.assertScope(scopes[i]);
            mappedScopes[i] = "SCOPE_" + scopes[i];
        }
        return AuthorityReactiveAuthorizationManager.hasAnyAuthority(mappedScopes);
    }

    private static void assertScope(String scope) {
        Assert.isTrue(!scope.startsWith("SCOPE_"), () -> scope + " should not start with SCOPE_ since SCOPE_ is automatically prepended when using hasScope and hasAnyScope. Consider using  AuthorityReactiveAuthorizationManager#hasAuthority or #hasAnyAuthority instead.");
    }
}

