/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.Map;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jwt.JoseHeader;
import org.springframework.util.Assert;

public final class JwsHeader
extends JoseHeader {
    private JwsHeader(Map<String, Object> headers) {
        super(headers);
    }

    public JwsAlgorithm getAlgorithm() {
        return (JwsAlgorithm)super.getAlgorithm();
    }

    public static Builder with(JwsAlgorithm jwsAlgorithm) {
        return new Builder(jwsAlgorithm);
    }

    public static Builder from(JwsHeader headers) {
        return new Builder(headers);
    }

    public static final class Builder
    extends JoseHeader.AbstractBuilder<JwsHeader, Builder> {
        private Builder(JwsAlgorithm jwsAlgorithm) {
            Assert.notNull((Object)jwsAlgorithm, "jwsAlgorithm cannot be null");
            this.algorithm(jwsAlgorithm);
        }

        private Builder(JwsHeader headers) {
            Assert.notNull((Object)headers, "headers cannot be null");
            this.getHeaders().putAll(headers.getHeaders());
        }

        @Override
        public JwsHeader build() {
            return new JwsHeader(this.getHeaders());
        }
    }
}

