/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.jwt.JwtClaimAccessor;
import org.springframework.util.Assert;

public final class JwtClaimsSet
implements JwtClaimAccessor {
    private final Map<String, Object> claims;

    private JwtClaimsSet(Map<String, Object> claims) {
        this.claims = Collections.unmodifiableMap(new HashMap<String, Object>(claims));
    }

    @Override
    public Map<String, Object> getClaims() {
        return this.claims;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(JwtClaimsSet claims) {
        return new Builder(claims);
    }

    public static final class Builder {
        private final Map<String, Object> claims = new HashMap<String, Object>();

        private Builder() {
        }

        private Builder(JwtClaimsSet claims) {
            Assert.notNull((Object)claims, "claims cannot be null");
            this.claims.putAll(claims.getClaims());
        }

        public Builder issuer(String issuer) {
            return this.claim("iss", issuer);
        }

        public Builder subject(String subject) {
            return this.claim("sub", subject);
        }

        public Builder audience(List<String> audience) {
            return this.claim("aud", audience);
        }

        public Builder expiresAt(Instant expiresAt) {
            return this.claim("exp", expiresAt);
        }

        public Builder notBefore(Instant notBefore) {
            return this.claim("nbf", notBefore);
        }

        public Builder issuedAt(Instant issuedAt) {
            return this.claim("iat", issuedAt);
        }

        public Builder id(String jti) {
            return this.claim("jti", jti);
        }

        public Builder claim(String name, Object value) {
            Assert.hasText(name, "name cannot be empty");
            Assert.notNull(value, "value cannot be null");
            this.claims.put(name, value);
            return this;
        }

        public Builder claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this;
        }

        public JwtClaimsSet build() {
            URL convertedValue;
            Assert.notEmpty(this.claims, "claims cannot be empty");
            Object issuer = this.claims.get("iss");
            if (issuer != null && (convertedValue = ClaimConversionService.getSharedInstance().convert(issuer, URL.class)) != null) {
                this.claims.put("iss", convertedValue);
            }
            return new JwtClaimsSet(this.claims);
        }
    }
}

