/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.util.Assert;

public final class JwtEncoderParameters {
    private final JwsHeader jwsHeader;
    private final JwtClaimsSet claims;

    private JwtEncoderParameters(JwsHeader jwsHeader, JwtClaimsSet claims) {
        this.jwsHeader = jwsHeader;
        this.claims = claims;
    }

    public static JwtEncoderParameters from(JwtClaimsSet claims) {
        Assert.notNull((Object)claims, "claims cannot be null");
        return new JwtEncoderParameters(null, claims);
    }

    public static JwtEncoderParameters from(JwsHeader jwsHeader, JwtClaimsSet claims) {
        Assert.notNull((Object)jwsHeader, "jwsHeader cannot be null");
        Assert.notNull((Object)claims, "claims cannot be null");
        return new JwtEncoderParameters(jwsHeader, claims);
    }

    @Nullable
    public JwsHeader getJwsHeader() {
        return this.jwsHeader;
    }

    public JwtClaimsSet getClaims() {
        return this.claims;
    }
}

