/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.security.oauth2.jwt.ReactiveRemoteJWKSource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ReactiveJwtDecoderProviderConfigurationUtils {
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private static final String OAUTH_METADATA_PATH = "/.well-known/oauth-authorization-server";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};

    static <C extends SecurityContext> Mono<ConfigurableJWTProcessor<C>> addJWSAlgorithms(ReactiveRemoteJWKSource jwkSource, ConfigurableJWTProcessor<C> jwtProcessor) {
        JWSKeySelector selector = jwtProcessor.getJWSKeySelector();
        if (!(selector instanceof JWSVerificationKeySelector)) {
            return Mono.just(jwtProcessor);
        }
        JWKSource delegate = ((JWSVerificationKeySelector)selector).getJWKSource();
        return ReactiveJwtDecoderProviderConfigurationUtils.getJWSAlgorithms(jwkSource).map(algorithms -> new JWSVerificationKeySelector((Set<JWSAlgorithm>)algorithms, delegate)).map(replacement -> {
            jwtProcessor.setJWSKeySelector((JWSKeySelector)replacement);
            return jwtProcessor;
        });
    }

    static Mono<Set<JWSAlgorithm>> getJWSAlgorithms(ReactiveRemoteJWKSource jwkSource) {
        JWKMatcher jwkMatcher = new JWKMatcher.Builder().publicOnly(true).keyUses(KeyUse.SIGNATURE, null).keyTypes(KeyType.RSA, KeyType.EC).build();
        return jwkSource.get(new JWKSelector(jwkMatcher)).map(jwks -> {
            HashSet<JWSAlgorithm> jwsAlgorithms = new HashSet<JWSAlgorithm>();
            for (JWK jwk : jwks) {
                if (jwk.getAlgorithm() != null) {
                    JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse(jwk.getAlgorithm().getName());
                    jwsAlgorithms.add(jwsAlgorithm);
                    continue;
                }
                if (jwk.getKeyType() == KeyType.RSA) {
                    jwsAlgorithms.addAll(JWSAlgorithm.Family.RSA);
                    continue;
                }
                if (jwk.getKeyType() != KeyType.EC) continue;
                jwsAlgorithms.addAll(JWSAlgorithm.Family.EC);
            }
            Assert.notEmpty(jwsAlgorithms, "Failed to find any algorithms from the JWK set");
            return jwsAlgorithms;
        }).onErrorMap(KeySourceException.class, IllegalStateException::new);
    }

    static Mono<Map<String, Object>> getConfigurationForIssuerLocation(String issuer, WebClient web) {
        URI uri = URI.create(issuer);
        return ReactiveJwtDecoderProviderConfigurationUtils.getConfiguration(issuer, web, ReactiveJwtDecoderProviderConfigurationUtils.oidc(uri), ReactiveJwtDecoderProviderConfigurationUtils.oidcRfc8414(uri), ReactiveJwtDecoderProviderConfigurationUtils.oauth(uri));
    }

    private static URI oidc(URI issuer) {
        return UriComponentsBuilder.fromUri(issuer).replacePath(issuer.getPath() + OIDC_METADATA_PATH).build(Collections.emptyMap());
    }

    private static URI oidcRfc8414(URI issuer) {
        return UriComponentsBuilder.fromUri(issuer).replacePath(OIDC_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }

    private static URI oauth(URI issuer) {
        return UriComponentsBuilder.fromUri(issuer).replacePath(OAUTH_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }

    private static Mono<Map<String, Object>> getConfiguration(String issuer, WebClient web, URI ... uris) {
        String errorMessage = "Unable to resolve the Configuration with the provided Issuer of \"" + issuer + "\"";
        return Flux.just((Object[])uris).concatMap(uri -> web.get().uri(uri).retrieve().bodyToMono(STRING_OBJECT_MAP)).flatMap(configuration -> {
            if (configuration.get("jwks_uri") == null) {
                return Mono.error(() -> new IllegalArgumentException("The public JWK set URI must not be null"));
            }
            return Mono.just((Object)configuration);
        }).onErrorContinue(ex -> ex instanceof WebClientResponseException && ((WebClientResponseException)ex).getStatusCode().is4xxClientError(), (ex, object) -> {}).onErrorMap(RuntimeException.class, ex -> ex instanceof IllegalArgumentException ? ex : new IllegalArgumentException(errorMessage, (Throwable)ex)).next().switchIfEmpty(Mono.error(() -> new IllegalArgumentException(errorMessage)));
    }

    private ReactiveJwtDecoderProviderConfigurationUtils() {
    }
}

