/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;

@Transient
public class BearerTokenAuthentication
extends AbstractOAuth2TokenAuthenticationToken<OAuth2AccessToken> {
    private static final long serialVersionUID = 620L;
    private final Map<String, Object> attributes;

    public BearerTokenAuthentication(OAuth2AuthenticatedPrincipal principal2, OAuth2AccessToken credentials, Collection<? extends GrantedAuthority> authorities) {
        super(credentials, principal2, credentials, authorities);
        Assert.isTrue(credentials.getTokenType() == OAuth2AccessToken.TokenType.BEARER, "credentials must be a bearer token");
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(principal2.getAttributes()));
        this.setAuthenticated(true);
    }

    @Override
    public Map<String, Object> getTokenAttributes() {
        return this.attributes;
    }
}

