/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.time.Instant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.util.Assert;

public final class OpaqueTokenAuthenticationProvider
implements AuthenticationProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final OpaqueTokenIntrospector introspector;
    private OpaqueTokenAuthenticationConverter authenticationConverter = OpaqueTokenAuthenticationProvider::convert;

    public OpaqueTokenAuthenticationProvider(OpaqueTokenIntrospector introspector) {
        Assert.notNull((Object)introspector, "introspector cannot be null");
        this.introspector = introspector;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AbstractAuthenticationToken auth;
        if (!(authentication instanceof BearerTokenAuthenticationToken)) {
            return null;
        }
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        OAuth2AuthenticatedPrincipal principal2 = this.getOAuth2AuthenticatedPrincipal(bearer);
        Authentication result = this.authenticationConverter.convert(bearer.getToken(), principal2);
        if (result == null) {
            return null;
        }
        if (AbstractAuthenticationToken.class.isAssignableFrom(result.getClass()) && (auth = (AbstractAuthenticationToken)result).getDetails() == null) {
            auth.setDetails(bearer.getDetails());
        }
        this.logger.debug("Authenticated token");
        return result;
    }

    private OAuth2AuthenticatedPrincipal getOAuth2AuthenticatedPrincipal(BearerTokenAuthenticationToken bearer) {
        try {
            return this.introspector.introspect(bearer.getToken());
        }
        catch (BadOpaqueTokenException failed) {
            this.logger.debug("Failed to authenticate since token was invalid");
            throw new InvalidBearerTokenException(failed.getMessage(), (Throwable)failed);
        }
        catch (OAuth2IntrospectionException failed) {
            throw new AuthenticationServiceException(failed.getMessage(), failed);
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    static BearerTokenAuthentication convert(String introspectedToken, OAuth2AuthenticatedPrincipal authenticatedPrincipal) {
        Instant iat = (Instant)authenticatedPrincipal.getAttribute("iat");
        Instant exp = (Instant)authenticatedPrincipal.getAttribute("exp");
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, introspectedToken, iat, exp);
        return new BearerTokenAuthentication(authenticatedPrincipal, accessToken, authenticatedPrincipal.getAuthorities());
    }

    public void setAuthenticationConverter(OpaqueTokenAuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, "authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }
}

