/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.introspection;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Audience;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class NimbusReactiveOpaqueTokenIntrospector
implements ReactiveOpaqueTokenIntrospector {
    private static final String AUTHORITY_PREFIX = "SCOPE_";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final URI introspectionUri;
    private final WebClient webClient;

    public NimbusReactiveOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.hasText(introspectionUri, "introspectionUri cannot be empty");
        Assert.hasText(clientId, "clientId cannot be empty");
        Assert.notNull((Object)clientSecret, "clientSecret cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = WebClient.builder().defaultHeaders(h -> h.setBasicAuth(clientId, clientSecret)).build();
    }

    public NimbusReactiveOpaqueTokenIntrospector(String introspectionUri, WebClient webClient) {
        Assert.hasText(introspectionUri, "introspectionUri cannot be null");
        Assert.notNull((Object)webClient, "webClient cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = webClient;
    }

    @Override
    public Mono<OAuth2AuthenticatedPrincipal> introspect(String token) {
        return Mono.just((Object)token).flatMap(this::makeRequest).flatMap(this::adaptToNimbusResponse).map(this::parseNimbusResponse).map(this::castToNimbusSuccess).doOnNext(response -> this.validate(token, (TokenIntrospectionSuccessResponse)response)).map(this::convertClaimsSet).onErrorMap(e -> !(e instanceof OAuth2IntrospectionException), this::onError);
    }

    private Mono<ClientResponse> makeRequest(String token) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.introspectionUri)).header("Accept", new String[]{"application/json"})).body((BodyInserter)BodyInserters.fromFormData((String)"token", (String)token)).exchange();
    }

    private Mono<HTTPResponse> adaptToNimbusResponse(ClientResponse responseEntity) {
        MediaType contentType = (MediaType)responseEntity.headers().contentType().orElseThrow(() -> {
            this.logger.trace("Did not receive Content-Type from introspection endpoint in response");
            return new OAuth2IntrospectionException("Introspection endpoint response was invalid, as no Content-Type header was provided");
        });
        if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
            this.logger.trace("Did not receive JSON-compatible Content-Type from introspection endpoint in response");
            throw new OAuth2IntrospectionException("Introspection endpoint response was invalid, as content type '" + contentType + "' is not compatible with JSON");
        }
        HTTPResponse response = new HTTPResponse(responseEntity.statusCode().value());
        response.setHeader("Content-Type", new String[]{contentType.toString()});
        if (response.getStatusCode() != 200) {
            this.logger.trace("Introspection endpoint returned non-OK status code");
            return responseEntity.bodyToFlux(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)new OAuth2IntrospectionException("Introspection endpoint responded with HTTP status code " + response.getStatusCode())));
        }
        return responseEntity.bodyToMono(String.class).doOnNext(response::setContent).map(body2 -> response);
    }

    private TokenIntrospectionResponse parseNimbusResponse(HTTPResponse response) {
        try {
            return TokenIntrospectionResponse.parse(response);
        }
        catch (Exception ex) {
            throw new OAuth2IntrospectionException(ex.getMessage(), ex);
        }
    }

    private TokenIntrospectionSuccessResponse castToNimbusSuccess(TokenIntrospectionResponse introspectionResponse) {
        if (!introspectionResponse.indicatesSuccess()) {
            ErrorObject errorObject = introspectionResponse.toErrorResponse().getErrorObject();
            String message = "Token introspection failed with response " + errorObject.toJSONObject().toJSONString();
            this.logger.trace(message);
            throw new OAuth2IntrospectionException(message);
        }
        return (TokenIntrospectionSuccessResponse)introspectionResponse;
    }

    private void validate(String token, TokenIntrospectionSuccessResponse response) {
        if (!response.isActive()) {
            this.logger.trace("Did not validate token since it is inactive");
            throw new BadOpaqueTokenException("Provided token isn't active");
        }
    }

    private OAuth2AuthenticatedPrincipal convertClaimsSet(TokenIntrospectionSuccessResponse response) {
        JSONObject claims = response.toJSONObject();
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        if (response.getAudience() != null) {
            ArrayList<String> audiences = new ArrayList<String>();
            for (Audience audience : response.getAudience()) {
                audiences.add(audience.getValue());
            }
            claims.put("aud", Collections.unmodifiableList(audiences));
        }
        if (response.getClientID() != null) {
            claims.put("client_id", response.getClientID().getValue());
        }
        if (response.getExpirationTime() != null) {
            Instant exp = response.getExpirationTime().toInstant();
            claims.put("exp", exp);
        }
        if (response.getIssueTime() != null) {
            Instant iat = response.getIssueTime().toInstant();
            claims.put("iat", iat);
        }
        if (response.getIssuer() != null) {
            claims.put("iss", response.getIssuer().getValue());
        }
        if (response.getNotBeforeTime() != null) {
            claims.put("nbf", response.getNotBeforeTime().toInstant());
        }
        if (response.getScope() != null) {
            List<String> scopes = Collections.unmodifiableList(response.getScope().toStringList());
            claims.put("scope", scopes);
            for (String scope : scopes) {
                authorities.add(new SimpleGrantedAuthority(AUTHORITY_PREFIX + scope));
            }
        }
        return new OAuth2IntrospectionAuthenticatedPrincipal(claims, authorities);
    }

    private OAuth2IntrospectionException onError(Throwable ex) {
        return new OAuth2IntrospectionException(ex.getMessage(), ex);
    }
}

