/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.access.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class BearerTokenServerAccessDeniedHandler
implements ServerAccessDeniedHandler {
    private static final Collection<String> WELL_KNOWN_SCOPE_ATTRIBUTE_NAMES = Arrays.asList("scope", "scp");
    private String realmName;

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2, AccessDeniedException denied) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (this.realmName != null) {
            parameters.put("realm", this.realmName);
        }
        return exchange2.getPrincipal().filter(AbstractOAuth2TokenAuthenticationToken.class::isInstance).map(token -> BearerTokenServerAccessDeniedHandler.errorMessageParameters(parameters)).switchIfEmpty(Mono.just(parameters)).flatMap(params -> BearerTokenServerAccessDeniedHandler.respond(exchange2, params));
    }

    public final void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    private static Map<String, String> errorMessageParameters(Map<String, String> parameters) {
        parameters.put("error", "insufficient_scope");
        parameters.put("error_description", "The request requires higher privileges than provided by the access token.");
        parameters.put("error_uri", "https://tools.ietf.org/html/rfc6750#section-3.1");
        return parameters;
    }

    private static Mono<Void> respond(ServerWebExchange exchange2, Map<String, String> parameters) {
        String wwwAuthenticate = BearerTokenServerAccessDeniedHandler.computeWWWAuthenticateHeaderValue(parameters);
        exchange2.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
        exchange2.getResponse().getHeaders().set("WWW-Authenticate", wwwAuthenticate);
        return exchange2.getResponse().setComplete();
    }

    private static String computeWWWAuthenticateHeaderValue(Map<String, String> parameters) {
        StringBuilder wwwAuthenticate = new StringBuilder();
        wwwAuthenticate.append("Bearer");
        if (!parameters.isEmpty()) {
            wwwAuthenticate.append(" ");
            int i = 0;
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                wwwAuthenticate.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                if (i != parameters.size() - 1) {
                    wwwAuthenticate.append(", ");
                }
                ++i;
            }
        }
        return wwwAuthenticate.toString();
    }
}

