/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.channel.ChannelDecisionManager;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class ChannelProcessingFilter
extends GenericFilterBean {
    private ChannelDecisionManager channelDecisionManager;
    private FilterInvocationSecurityMetadataSource securityMetadataSource;

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.securityMetadataSource, "securityMetadataSource must be specified");
        Assert.notNull((Object)this.channelDecisionManager, "channelDecisionManager must be specified");
        Collection<ConfigAttribute> attributes = this.securityMetadataSource.getAllConfigAttributes();
        if (attributes == null) {
            this.logger.warn("Could not validate configuration attributes as the FilterInvocationSecurityMetadataSource did not return any attributes");
            return;
        }
        Set<ConfigAttribute> unsupportedAttributes = this.getUnsupportedAttributes(attributes);
        Assert.isTrue(unsupportedAttributes.isEmpty(), () -> "Unsupported configuration attributes: " + unsupportedAttributes);
        this.logger.info("Validated configuration attributes");
    }

    private Set<ConfigAttribute> getUnsupportedAttributes(Collection<ConfigAttribute> attrDefs) {
        HashSet<ConfigAttribute> unsupportedAttributes = new HashSet<ConfigAttribute>();
        for (ConfigAttribute attr : attrDefs) {
            if (this.channelDecisionManager.supports(attr)) continue;
            unsupportedAttributes.add(attr);
        }
        return unsupportedAttributes;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        FilterInvocation filterInvocation = new FilterInvocation(request, response, chain);
        Collection<ConfigAttribute> attributes = this.securityMetadataSource.getAttributes(filterInvocation);
        if (attributes != null) {
            this.logger.debug(LogMessage.format("Request: %s; ConfigAttributes: %s", (Object)filterInvocation, attributes));
            this.channelDecisionManager.decide(filterInvocation, attributes);
            if (filterInvocation.getResponse().isCommitted()) {
                return;
            }
        }
        chain.doFilter(request, response);
    }

    protected ChannelDecisionManager getChannelDecisionManager() {
        return this.channelDecisionManager;
    }

    protected FilterInvocationSecurityMetadataSource getSecurityMetadataSource() {
        return this.securityMetadataSource;
    }

    public void setChannelDecisionManager(ChannelDecisionManager channelDecisionManager) {
        this.channelDecisionManager = channelDecisionManager;
    }

    public void setSecurityMetadataSource(FilterInvocationSecurityMetadataSource filterInvocationSecurityMetadataSource) {
        this.securityMetadataSource = filterInvocationSecurityMetadataSource;
    }
}

