/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.websphere;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.log.LogMessage;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.websphere.DefaultWASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WebSpherePreAuthenticatedWebAuthenticationDetailsSource;

public class WebSpherePreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private final WASUsernameAndGroupsExtractor wasHelper;

    public WebSpherePreAuthenticatedProcessingFilter() {
        this(new DefaultWASUsernameAndGroupsExtractor());
    }

    WebSpherePreAuthenticatedProcessingFilter(WASUsernameAndGroupsExtractor wasHelper) {
        this.wasHelper = wasHelper;
        this.setAuthenticationDetailsSource(new WebSpherePreAuthenticatedWebAuthenticationDetailsSource());
    }

    @Override
    protected Object getPreAuthenticatedPrincipal(HttpServletRequest httpRequest) {
        String principal2 = this.wasHelper.getCurrentUserName();
        this.logger.debug(LogMessage.format("PreAuthenticated WebSphere principal: %s", (Object)principal2));
        return principal2;
    }

    @Override
    protected Object getPreAuthenticatedCredentials(HttpServletRequest httpRequest) {
        return "N/A";
    }
}

