/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.savedrequest;

import java.net.URI;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.util.matcher.AndServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class WebSessionServerRequestCache
implements ServerRequestCache {
    private static final String DEFAULT_SAVED_REQUEST_ATTR = "SPRING_SECURITY_SAVED_REQUEST";
    private static final Log logger = LogFactory.getLog(WebSessionServerRequestCache.class);
    private String sessionAttrName = "SPRING_SECURITY_SAVED_REQUEST";
    private ServerWebExchangeMatcher saveRequestMatcher = WebSessionServerRequestCache.createDefaultRequestMacher();
    private String matchingRequestParameterName;

    public void setSaveRequestMatcher(ServerWebExchangeMatcher saveRequestMatcher) {
        Assert.notNull((Object)saveRequestMatcher, "saveRequestMatcher cannot be null");
        this.saveRequestMatcher = saveRequestMatcher;
    }

    @Override
    public Mono<Void> saveRequest(ServerWebExchange exchange2) {
        return this.saveRequestMatcher.matches(exchange2).filter(ServerWebExchangeMatcher.MatchResult::isMatch).flatMap(m -> exchange2.getSession()).map(WebSession::getAttributes).doOnNext(attrs -> {
            String requestPath = WebSessionServerRequestCache.pathInApplication(exchange2.getRequest());
            attrs.put(this.sessionAttrName, requestPath);
            logger.debug(LogMessage.format("Request added to WebSession: '%s'", (Object)requestPath));
        }).then();
    }

    @Override
    public Mono<URI> getRedirectUri(ServerWebExchange exchange2) {
        return exchange2.getSession().flatMap(session -> Mono.justOrEmpty((Object)((String)session.getAttribute(this.sessionAttrName)))).map(this::createRedirectUri);
    }

    @Override
    public Mono<ServerHttpRequest> removeMatchingRequest(ServerWebExchange exchange2) {
        MultiValueMap<String, String> queryParams = exchange2.getRequest().getQueryParams();
        if (this.matchingRequestParameterName != null && !queryParams.containsKey(this.matchingRequestParameterName)) {
            logger.trace("matchingRequestParameterName is required for getMatchingRequest to lookup a value, but not provided");
            return Mono.empty();
        }
        ServerHttpRequest request = this.stripMatchingRequestParameterName(exchange2.getRequest());
        return exchange2.getSession().map(WebSession::getAttributes).filter(attributes -> {
            String requestPath = WebSessionServerRequestCache.pathInApplication(request);
            boolean removed = attributes.remove(this.sessionAttrName, requestPath);
            if (removed) {
                logger.debug(LogMessage.format("Request removed from WebSession: '%s'", (Object)requestPath));
            }
            return removed;
        }).map(attributes -> request);
    }

    public void setMatchingRequestParameterName(String matchingRequestParameterName) {
        this.matchingRequestParameterName = matchingRequestParameterName;
    }

    private ServerHttpRequest stripMatchingRequestParameterName(ServerHttpRequest request) {
        if (this.matchingRequestParameterName == null) {
            return request;
        }
        URI uri = UriComponentsBuilder.fromUri(request.getURI()).replaceQueryParam(this.matchingRequestParameterName, new Object[0]).build().toUri();
        return request.mutate().uri(uri).build();
    }

    private static String pathInApplication(ServerHttpRequest request) {
        String path = request.getPath().pathWithinApplication().value();
        String query = request.getURI().getRawQuery();
        return path + (String)(query != null ? "?" + query : "");
    }

    private URI createRedirectUri(String uri) {
        if (this.matchingRequestParameterName == null) {
            return URI.create(uri);
        }
        return UriComponentsBuilder.fromUriString(uri).queryParam(this.matchingRequestParameterName, new Object[0]).build().toUri();
    }

    private static ServerWebExchangeMatcher createDefaultRequestMacher() {
        ServerWebExchangeMatcher get = ServerWebExchangeMatchers.pathMatchers(HttpMethod.GET, "/**");
        NegatedServerWebExchangeMatcher notFavicon = new NegatedServerWebExchangeMatcher(ServerWebExchangeMatchers.pathMatchers("/favicon.*"));
        MediaTypeServerWebExchangeMatcher html = new MediaTypeServerWebExchangeMatcher(MediaType.TEXT_HTML);
        html.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        return new AndServerWebExchangeMatcher(get, notFavicon, html);
    }

    private static String createQueryString(String queryString, String matchingRequestParameterName) {
        if (matchingRequestParameterName == null) {
            return queryString;
        }
        if (queryString == null || queryString.length() == 0) {
            return matchingRequestParameterName;
        }
        if (queryString.endsWith("&")) {
            return queryString + matchingRequestParameterName;
        }
        return queryString + "&" + matchingRequestParameterName;
    }
}

