/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public class DispatcherTypeRequestMatcher
implements RequestMatcher {
    private final DispatcherType dispatcherType;
    @Nullable
    private final HttpMethod httpMethod;

    public DispatcherTypeRequestMatcher(DispatcherType dispatcherType) {
        this(dispatcherType, null);
    }

    public DispatcherTypeRequestMatcher(DispatcherType dispatcherType, @Nullable HttpMethod httpMethod) {
        this.dispatcherType = dispatcherType;
        this.httpMethod = httpMethod;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        if (this.httpMethod != null && StringUtils.hasText(request.getMethod()) && this.httpMethod != HttpMethod.valueOf(request.getMethod())) {
            return false;
        }
        return this.dispatcherType == request.getDispatcherType();
    }

    public String toString() {
        return "DispatcherTypeRequestMatcher{dispatcherType=" + this.dispatcherType + ", httpMethod=" + this.httpMethod + "}";
    }
}

