/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.QueryParameterUtils;

public class RequestPathAttribute
implements ExchangeAttribute {
    public static final String REQUEST_PATH = "%{REQUEST_PATH}";
    public static final ExchangeAttribute INSTANCE = new RequestPathAttribute();

    private RequestPathAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        return exchange2.getRelativePath();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        int pos = newValue.indexOf(63);
        exchange2.setResolvedPath("");
        if (pos == -1) {
            exchange2.setRelativePath(newValue);
            exchange2.setRequestURI(newValue);
            exchange2.setRequestPath(newValue);
        } else {
            String path = newValue.substring(0, pos);
            exchange2.setRequestPath(path);
            exchange2.setRelativePath(path);
            exchange2.setRequestURI(newValue);
            String newQueryString = newValue.substring(pos);
            exchange2.setQueryString(newQueryString);
            exchange2.getQueryParameters().putAll(QueryParameterUtils.parseQueryString(newQueryString.substring(1), QueryParameterUtils.getQueryParamEncoding(exchange2)));
        }
    }

    public String toString() {
        return REQUEST_PATH;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request Path";
        }

        @Override
        public ExchangeAttribute build(String token) {
            return token.equals(RequestPathAttribute.REQUEST_PATH) ? INSTANCE : null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

