/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;

public class ResponseHeaderAttribute
implements ExchangeAttribute {
    private final HttpString responseHeader;

    public ResponseHeaderAttribute(HttpString responseHeader) {
        this.responseHeader = responseHeader;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        HeaderValues header = exchange2.getResponseHeaders().get(this.responseHeader);
        if (header == null) {
            return null;
        }
        if (header.size() == 1) {
            return header.getFirst();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < header.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(header.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        exchange2.getResponseHeaders().put(this.responseHeader, newValue);
    }

    public String toString() {
        return "%{o," + this.responseHeader + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{o,") && token.endsWith("}")) {
                HttpString headerName = HttpString.tryFromString(token.substring(4, token.length() - 1));
                return new ResponseHeaderAttribute(headerName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

