/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.util.BadRequestException;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.LegacyCookieSupport;
import io.undertow.util.ParameterLimitException;
import io.undertow.util.URLUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.xnio.OptionMap;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;

public class Connectors {
    private static final boolean[] ALLOWED_TOKEN_CHARACTERS;
    private static final boolean[] ALLOWED_SCHEME_CHARACTERS;

    public static void flattenCookies(HttpServerExchange exchange2) {
        boolean enableRfc6265Validation = exchange2.getConnection().getUndertowOptions().get(UndertowOptions.ENABLE_RFC6265_COOKIE_VALIDATION, false);
        for (Cookie cookie : exchange2.responseCookies()) {
            exchange2.getResponseHeaders().add(Headers.SET_COOKIE, Connectors.getCookieString(cookie, enableRfc6265Validation));
        }
    }

    public static void addCookie(HttpServerExchange exchange2, Cookie cookie) {
        boolean enableRfc6265Validation = exchange2.getConnection().getUndertowOptions().get(UndertowOptions.ENABLE_RFC6265_COOKIE_VALIDATION, false);
        exchange2.getResponseHeaders().add(Headers.SET_COOKIE, Connectors.getCookieString(cookie, enableRfc6265Validation));
    }

    public static void ungetRequestBytes(HttpServerExchange exchange2, PooledByteBuffer ... buffers) {
        PooledByteBuffer[] newArray;
        PooledByteBuffer[] existing = exchange2.getAttachment(HttpServerExchange.BUFFERED_REQUEST_DATA);
        if (existing == null) {
            newArray = new PooledByteBuffer[buffers.length];
            System.arraycopy(buffers, 0, newArray, 0, buffers.length);
        } else {
            newArray = new PooledByteBuffer[existing.length + buffers.length];
            System.arraycopy(buffers, 0, newArray, 0, buffers.length);
            System.arraycopy(existing, 0, newArray, buffers.length, existing.length);
        }
        exchange2.putAttachment(HttpServerExchange.BUFFERED_REQUEST_DATA, newArray);
        exchange2.addExchangeCompleteListener(BufferedRequestDataCleanupListener.INSTANCE);
    }

    public static void terminateRequest(HttpServerExchange exchange2) {
        exchange2.terminateRequest();
    }

    public static void terminateResponse(HttpServerExchange exchange2) {
        exchange2.terminateResponse();
    }

    public static void resetRequestChannel(HttpServerExchange exchange2) {
        exchange2.resetRequestChannel();
    }

    private static String getCookieString(Cookie cookie, boolean enableRfc6265Validation) {
        if (enableRfc6265Validation) {
            return Connectors.addRfc6265ResponseCookieToExchange(cookie);
        }
        switch (LegacyCookieSupport.adjustedCookieVersion(cookie)) {
            case 0: {
                return Connectors.addVersion0ResponseCookieToExchange(cookie);
            }
        }
        return Connectors.addVersion1ResponseCookieToExchange(cookie);
    }

    public static void setRequestStartTime(HttpServerExchange exchange2) {
        exchange2.setRequestStartTime(System.nanoTime());
    }

    public static void setRequestStartTime(HttpServerExchange existing, HttpServerExchange newExchange) {
        newExchange.setRequestStartTime(existing.getRequestStartTime());
    }

    private static String addRfc6265ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        if (cookie.getValue() != null) {
            header.append(cookie.getValue());
        }
        if (cookie.getPath() != null) {
            header.append("; Path=");
            header.append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; Domain=");
            header.append(cookie.getDomain());
        }
        if (cookie.isDiscard()) {
            header.append("; Discard");
        }
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() >= 0) {
                header.append("; Max-Age=");
                header.append(cookie.getMaxAge());
            }
            if (cookie.getExpires() == null) {
                if (cookie.getMaxAge() == 0) {
                    Date expires = new Date();
                    expires.setTime(0L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                } else if (cookie.getMaxAge() > 0) {
                    Date expires = new Date();
                    expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue() * 1000L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                }
            }
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toDateString(cookie.getExpires()));
        }
        if (cookie.getComment() != null && !cookie.getComment().isEmpty()) {
            header.append("; Comment=");
            header.append(cookie.getComment());
        }
        if (cookie.isSameSite() && cookie.getSameSiteMode() != null && !cookie.getSameSiteMode().isEmpty()) {
            header.append("; SameSite=");
            header.append(cookie.getSameSiteMode());
        }
        return header.toString();
    }

    private static String addVersion0ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        if (cookie.getValue() != null) {
            LegacyCookieSupport.maybeQuote(header, cookie.getValue());
        }
        if (cookie.getPath() != null) {
            header.append("; path=");
            LegacyCookieSupport.maybeQuote(header, cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; domain=");
            LegacyCookieSupport.maybeQuote(header, cookie.getDomain());
        }
        if (cookie.isSecure()) {
            header.append("; secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toOldCookieDateString(cookie.getExpires()));
        } else if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() >= 0) {
                header.append("; Max-Age=");
                header.append(cookie.getMaxAge());
            }
            if (cookie.getMaxAge() == 0) {
                Date expires = new Date();
                expires.setTime(0L);
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            } else if (cookie.getMaxAge() > 0) {
                Date expires = new Date();
                expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue() * 1000L);
                header.append("; Expires=");
                header.append(DateUtils.toOldCookieDateString(expires));
            }
        }
        if (cookie.isSameSite() && cookie.getSameSiteMode() != null && !cookie.getSameSiteMode().isEmpty()) {
            header.append("; SameSite=");
            header.append(cookie.getSameSiteMode());
        }
        return header.toString();
    }

    private static String addVersion1ResponseCookieToExchange(Cookie cookie) {
        StringBuilder header = new StringBuilder(cookie.getName());
        header.append("=");
        if (cookie.getValue() != null) {
            LegacyCookieSupport.maybeQuote(header, cookie.getValue());
        }
        header.append("; Version=1");
        if (cookie.getPath() != null) {
            header.append("; Path=");
            LegacyCookieSupport.maybeQuote(header, cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            header.append("; Domain=");
            LegacyCookieSupport.maybeQuote(header, cookie.getDomain());
        }
        if (cookie.isDiscard()) {
            header.append("; Discard");
        }
        if (cookie.isSecure()) {
            header.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            header.append("; HttpOnly");
        }
        if (cookie.getMaxAge() != null) {
            if (cookie.getMaxAge() >= 0) {
                header.append("; Max-Age=");
                header.append(cookie.getMaxAge());
            }
            if (cookie.getExpires() == null) {
                if (cookie.getMaxAge() == 0) {
                    Date expires = new Date();
                    expires.setTime(0L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                } else if (cookie.getMaxAge() > 0) {
                    Date expires = new Date();
                    expires.setTime(expires.getTime() + (long)cookie.getMaxAge().intValue() * 1000L);
                    header.append("; Expires=");
                    header.append(DateUtils.toOldCookieDateString(expires));
                }
            }
        }
        if (cookie.getExpires() != null) {
            header.append("; Expires=");
            header.append(DateUtils.toDateString(cookie.getExpires()));
        }
        if (cookie.getComment() != null && !cookie.getComment().isEmpty()) {
            header.append("; Comment=");
            LegacyCookieSupport.maybeQuote(header, cookie.getComment());
        }
        if (cookie.isSameSite() && cookie.getSameSiteMode() != null && !cookie.getSameSiteMode().isEmpty()) {
            header.append("; SameSite=");
            header.append(cookie.getSameSiteMode());
        }
        return header.toString();
    }

    public static void executeRootHandler(HttpHandler handler, HttpServerExchange exchange2) {
        try {
            exchange2.setInCall(true);
            handler.handleRequest(exchange2);
            exchange2.setInCall(false);
            boolean resumed = exchange2.isResumed();
            if (exchange2.isDispatched()) {
                if (resumed) {
                    UndertowLogger.REQUEST_LOGGER.resumedAndDispatched();
                    exchange2.setStatusCode(500);
                    exchange2.endExchange();
                    return;
                }
                Runnable dispatchTask = exchange2.getDispatchTask();
                Executor executor = exchange2.getDispatchExecutor();
                exchange2.setDispatchExecutor(null);
                exchange2.unDispatch();
                if (dispatchTask != null) {
                    executor = executor == null ? exchange2.getConnection().getWorker() : executor;
                    try {
                        executor.execute(dispatchTask);
                    }
                    catch (RejectedExecutionException e) {
                        UndertowLogger.REQUEST_LOGGER.debug("Failed to dispatch to worker", e);
                        exchange2.setStatusCode(503);
                        exchange2.endExchange();
                    }
                }
            } else if (!resumed) {
                exchange2.endExchange();
            } else {
                exchange2.runResumeReadWrite();
            }
        }
        catch (Throwable t) {
            exchange2.putAttachment(DefaultResponseListener.EXCEPTION, t);
            exchange2.setInCall(false);
            if (!exchange2.isResponseStarted()) {
                exchange2.setStatusCode(500);
            }
            if (t instanceof IOException) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)t);
            } else {
                UndertowLogger.REQUEST_LOGGER.undertowRequestFailed(t, exchange2);
            }
            exchange2.endExchange();
        }
    }

    @Deprecated
    public static void setExchangeRequestPath(HttpServerExchange exchange2, String encodedPath, String charset, boolean decode, boolean allowEncodedSlash, StringBuilder decodeBuffer) {
        try {
            boolean slashDecodingFlag = URLUtils.getSlashDecodingFlag(allowEncodedSlash, exchange2.getConnection().getUndertowOptions().get(UndertowOptions.DECODE_SLASH));
            Connectors.setExchangeRequestPath(exchange2, encodedPath, charset, decode, slashDecodingFlag, decodeBuffer, exchange2.getConnection().getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, 1000));
        }
        catch (BadRequestException | ParameterLimitException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setExchangeRequestPath(HttpServerExchange exchange2, String encodedPath, StringBuilder decodeBuffer) throws ParameterLimitException, BadRequestException {
        OptionMap options = exchange2.getConnection().getUndertowOptions();
        boolean slashDecodingFlag = URLUtils.getSlashDecodingFlag(options);
        Connectors.setExchangeRequestPath(exchange2, encodedPath, options.get(UndertowOptions.URL_CHARSET, StandardCharsets.UTF_8.name()), options.get(UndertowOptions.DECODE_URL, true), slashDecodingFlag, decodeBuffer, options.get(UndertowOptions.MAX_PARAMETERS, 1000));
    }

    public static void setExchangeRequestPath(HttpServerExchange exchange2, String encodedPath, String charset, boolean decode, boolean decodeSlashFlag, StringBuilder decodeBuffer, int maxParameters) throws ParameterLimitException, BadRequestException {
        Connectors.setExchangeRequestPath(exchange2, encodedPath, charset, decode, decode, decodeSlashFlag, decodeBuffer, maxParameters);
    }

    public static void setExchangeRequestPath(HttpServerExchange exchange2, String encodedPath, String charset, boolean decode, boolean decodeQueryString, boolean decodeSlashFlag, StringBuilder decodeBuffer, int maxParameters) throws ParameterLimitException, BadRequestException {
        OptionMap options = exchange2.getConnection().getUndertowOptions();
        boolean allowUnescapedCharactersInUrl = options.get(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, false);
        boolean requiresDecode = false;
        StringBuilder pathBuilder = new StringBuilder();
        int currentPathPartIndex = 0;
        for (int i = 0; i < encodedPath.length(); ++i) {
            String uri;
            String part;
            String encodedPart;
            char c = encodedPath.charAt(i);
            if (!allowUnescapedCharactersInUrl && !HttpRequestParser.isTargetCharacterAllowed(c)) {
                throw new BadRequestException(UndertowMessages.MESSAGES.invalidCharacterInRequestTarget(c));
            }
            if (c == '?') {
                encodedPart = encodedPath.substring(currentPathPartIndex, i);
                part = requiresDecode ? URLUtils.decode(encodedPart, charset, decodeSlashFlag, false, decodeBuffer) : encodedPart;
                pathBuilder.append(part);
                part = pathBuilder.toString();
                exchange2.setRequestPath(part);
                exchange2.setRelativePath(part);
                if (requiresDecode && allowUnescapedCharactersInUrl) {
                    uri = URLUtils.decode(encodedPath.substring(0, i), charset, decodeSlashFlag, false, decodeBuffer);
                    exchange2.setRequestURI(uri);
                } else {
                    exchange2.setRequestURI(encodedPath.substring(0, i));
                }
                String qs = encodedPath.substring(i + 1);
                if (requiresDecode && allowUnescapedCharactersInUrl) {
                    String decodedQS = URLUtils.decode(qs, charset, decodeSlashFlag, false, decodeBuffer);
                    exchange2.setQueryString(decodedQS);
                } else {
                    exchange2.setQueryString(qs);
                }
                URLUtils.parseQueryString(qs, exchange2, charset, decodeQueryString, maxParameters);
                return;
            }
            if (c == ';') {
                encodedPart = encodedPath.substring(currentPathPartIndex, i);
                part = requiresDecode ? URLUtils.decode(encodedPart, charset, decodeSlashFlag, false, decodeBuffer) : encodedPart;
                pathBuilder.append(part);
                if (requiresDecode && allowUnescapedCharactersInUrl) {
                    uri = URLUtils.decode(encodedPath, charset, decodeSlashFlag, false, decodeBuffer);
                    exchange2.setRequestURI(uri);
                } else {
                    exchange2.setRequestURI(encodedPath);
                }
                currentPathPartIndex = i + 1 + URLUtils.parsePathParams(encodedPath.substring(i + 1), exchange2, charset, decode, maxParameters);
                i = currentPathPartIndex - 1;
                continue;
            }
            if (!decode || c != '+' && c != '%' && c <= '\u007f') continue;
            requiresDecode = decode;
        }
        String encodedPart = encodedPath.substring(currentPathPartIndex);
        String part = requiresDecode ? URLUtils.decode(encodedPart, charset, decodeSlashFlag, false, decodeBuffer) : encodedPart;
        pathBuilder.append(part);
        part = pathBuilder.toString();
        exchange2.setRequestPath(part);
        exchange2.setRelativePath(part);
        exchange2.setRequestURI(encodedPath);
    }

    public static StreamSourceChannel getExistingRequestChannel(HttpServerExchange exchange2) {
        return exchange2.requestChannel;
    }

    public static boolean isEntityBodyAllowed(HttpServerExchange exchange2) {
        int code = exchange2.getStatusCode();
        return Connectors.isEntityBodyAllowed(code);
    }

    public static boolean isEntityBodyAllowed(int code) {
        if (code >= 100 && code < 200) {
            return false;
        }
        return code != 204 && code != 304;
    }

    public static void updateResponseBytesSent(HttpServerExchange exchange2, long bytes) {
        exchange2.updateBytesSent(bytes);
    }

    public static ConduitStreamSinkChannel getConduitSinkChannel(HttpServerExchange exchange2) {
        return exchange2.getConnection().getSinkChannel();
    }

    public static void verifyToken(HttpString header) {
        int length = header.length();
        for (int i = 0; i < length; ++i) {
            byte c = header.byteAt(i);
            if (ALLOWED_TOKEN_CHARACTERS[c]) continue;
            throw UndertowMessages.MESSAGES.invalidToken(c);
        }
    }

    public static boolean isValidTokenCharacter(byte c) {
        return ALLOWED_TOKEN_CHARACTERS[c];
    }

    public static boolean isValidSchemeCharacter(byte c) {
        return ALLOWED_SCHEME_CHARACTERS[c];
    }

    public static boolean areRequestHeadersValid(HeaderMap headers) {
        HeaderValues te = headers.get(Headers.TRANSFER_ENCODING);
        HeaderValues cl = headers.get(Headers.CONTENT_LENGTH);
        if (te != null && cl != null) {
            return false;
        }
        if (te != null && te.size() > 1) {
            return false;
        }
        return cl == null || cl.size() <= 1;
    }

    static {
        int i;
        ALLOWED_TOKEN_CHARACTERS = new boolean[256];
        ALLOWED_SCHEME_CHARACTERS = new boolean[256];
        block6: for (i = 0; i < ALLOWED_TOKEN_CHARACTERS.length; ++i) {
            if (i >= 48 && i <= 57 || i >= 97 && i <= 122 || i >= 65 && i <= 90) {
                Connectors.ALLOWED_TOKEN_CHARACTERS[i] = true;
                continue;
            }
            switch (i) {
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 94: 
                case 95: 
                case 96: 
                case 124: 
                case 126: {
                    Connectors.ALLOWED_TOKEN_CHARACTERS[i] = true;
                    continue block6;
                }
                default: {
                    Connectors.ALLOWED_TOKEN_CHARACTERS[i] = false;
                }
            }
        }
        block7: for (i = 0; i < ALLOWED_SCHEME_CHARACTERS.length; ++i) {
            if (i >= 48 && i <= 57 || i >= 97 && i <= 122 || i >= 65 && i <= 90) {
                Connectors.ALLOWED_SCHEME_CHARACTERS[i] = true;
                continue;
            }
            switch (i) {
                case 43: 
                case 45: 
                case 46: {
                    Connectors.ALLOWED_SCHEME_CHARACTERS[i] = true;
                    continue block7;
                }
                default: {
                    Connectors.ALLOWED_SCHEME_CHARACTERS[i] = false;
                }
            }
        }
    }

    private static enum BufferedRequestDataCleanupListener implements ExchangeCompletionListener
    {
        INSTANCE;


        @Override
        public void exchangeEvent(HttpServerExchange exchange2, ExchangeCompletionListener.NextListener nextListener) {
            PooledByteBuffer[] bufs = exchange2.getAttachment(HttpServerExchange.BUFFERED_REQUEST_DATA);
            if (bufs != null) {
                for (PooledByteBuffer i : bufs) {
                    if (i == null) continue;
                    i.close();
                }
            }
            nextListener.proceed();
        }
    }
}

