/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.conduits.HeadStreamSinkConduit;
import io.undertow.conduits.RangeStreamSinkConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.ByteRange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.DateUtils;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xnio.conduits.StreamSinkConduit;

public class ByteRangeHandler
implements HttpHandler {
    private final HttpHandler next;
    private final boolean sendAcceptRanges;
    private static final ResponseCommitListener ACCEPT_RANGE_LISTENER = new ResponseCommitListener(){

        @Override
        public void beforeCommit(HttpServerExchange exchange2) {
            if (!exchange2.getResponseHeaders().contains(Headers.ACCEPT_RANGES)) {
                if (exchange2.getResponseHeaders().contains(Headers.CONTENT_LENGTH)) {
                    exchange2.getResponseHeaders().put(Headers.ACCEPT_RANGES, "bytes");
                } else {
                    exchange2.getResponseHeaders().put(Headers.ACCEPT_RANGES, "none");
                }
            }
        }
    };

    public ByteRangeHandler(HttpHandler next, boolean sendAcceptRanges) {
        this.next = next;
        this.sendAcceptRanges = sendAcceptRanges;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        ByteRange range;
        if (!Methods.GET.equals(exchange2.getRequestMethod()) && !Methods.HEAD.equals(exchange2.getRequestMethod())) {
            this.next.handleRequest(exchange2);
            return;
        }
        if (this.sendAcceptRanges) {
            exchange2.addResponseCommitListener(ACCEPT_RANGE_LISTENER);
        }
        if ((range = ByteRange.parse(exchange2.getRequestHeaders().getFirst(Headers.RANGE))) != null && range.getRanges() == 1) {
            exchange2.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

                @Override
                public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange2) {
                    if (exchange2.getStatusCode() != 200) {
                        return factory.create();
                    }
                    String length = exchange2.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
                    if (length == null) {
                        return factory.create();
                    }
                    long responseLength = Long.parseLong(length);
                    String lastModified = exchange2.getResponseHeaders().getFirst(Headers.LAST_MODIFIED);
                    ByteRange.RangeResponseResult rangeResponse = range.getResponseResult(responseLength, exchange2.getRequestHeaders().getFirst(Headers.IF_RANGE), lastModified == null ? null : DateUtils.parseDate(lastModified), exchange2.getResponseHeaders().getFirst(Headers.ETAG));
                    if (rangeResponse != null) {
                        long start = rangeResponse.getStart();
                        long end = rangeResponse.getEnd();
                        exchange2.setStatusCode(rangeResponse.getStatusCode());
                        exchange2.getResponseHeaders().put(Headers.CONTENT_RANGE, rangeResponse.getContentRange());
                        exchange2.setResponseContentLength(rangeResponse.getContentLength());
                        if (rangeResponse.getStatusCode() == 416) {
                            return new HeadStreamSinkConduit(factory.create(), null, true);
                        }
                        return new RangeStreamSinkConduit(factory.create(), start, end, responseLength);
                    }
                    return factory.create();
                }
            });
        }
        this.next.handleRequest(exchange2);
    }

    public String toString() {
        return "byte-range( " + this.sendAcceptRanges + " )";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "byte-range";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("send-accept-ranges", Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return "send-accept-ranges";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            Boolean send = (Boolean)config.get("send-accept-ranges");
            return new Wrapper(send != null && send != false);
        }
    }

    public static class Wrapper
    implements HandlerWrapper {
        private final boolean sendAcceptRanges;

        public Wrapper(boolean sendAcceptRanges) {
            this.sendAcceptRanges = sendAcceptRanges;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new ByteRangeHandler(handler, this.sendAcceptRanges);
        }
    }
}

